/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmeetings.model.AttendeeCapabilities;
import software.amazon.awssdk.services.chimesdkmeetings.model.AttendeeIdItem;
import software.amazon.awssdk.services.chimesdkmeetings.model.AttendeeIdsListCopier;
import software.amazon.awssdk.services.chimesdkmeetings.model.ChimeSdkMeetingsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateAttendeeCapabilitiesExceptRequest
extends ChimeSdkMeetingsRequest
implements ToCopyableBuilder<Builder, BatchUpdateAttendeeCapabilitiesExceptRequest> {
    private static final SdkField<String> MEETING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeetingId").getter(BatchUpdateAttendeeCapabilitiesExceptRequest.getter(BatchUpdateAttendeeCapabilitiesExceptRequest::meetingId)).setter(BatchUpdateAttendeeCapabilitiesExceptRequest.setter(Builder::meetingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("MeetingId").build()}).build();
    private static final SdkField<List<AttendeeIdItem>> EXCLUDED_ATTENDEE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludedAttendeeIds").getter(BatchUpdateAttendeeCapabilitiesExceptRequest.getter(BatchUpdateAttendeeCapabilitiesExceptRequest::excludedAttendeeIds)).setter(BatchUpdateAttendeeCapabilitiesExceptRequest.setter(Builder::excludedAttendeeIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedAttendeeIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttendeeIdItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AttendeeCapabilities> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Capabilities").getter(BatchUpdateAttendeeCapabilitiesExceptRequest.getter(BatchUpdateAttendeeCapabilitiesExceptRequest::capabilities)).setter(BatchUpdateAttendeeCapabilitiesExceptRequest.setter(Builder::capabilities)).constructor(AttendeeCapabilities::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEETING_ID_FIELD, EXCLUDED_ATTENDEE_IDS_FIELD, CAPABILITIES_FIELD));
    private final String meetingId;
    private final List<AttendeeIdItem> excludedAttendeeIds;
    private final AttendeeCapabilities capabilities;

    private BatchUpdateAttendeeCapabilitiesExceptRequest(BuilderImpl builder) {
        super(builder);
        this.meetingId = builder.meetingId;
        this.excludedAttendeeIds = builder.excludedAttendeeIds;
        this.capabilities = builder.capabilities;
    }

    public final String meetingId() {
        return this.meetingId;
    }

    public final boolean hasExcludedAttendeeIds() {
        return this.excludedAttendeeIds != null && !(this.excludedAttendeeIds instanceof SdkAutoConstructList);
    }

    public final List<AttendeeIdItem> excludedAttendeeIds() {
        return this.excludedAttendeeIds;
    }

    public final AttendeeCapabilities capabilities() {
        return this.capabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.meetingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludedAttendeeIds() ? this.excludedAttendeeIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilities());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateAttendeeCapabilitiesExceptRequest)) {
            return false;
        }
        BatchUpdateAttendeeCapabilitiesExceptRequest other = (BatchUpdateAttendeeCapabilitiesExceptRequest)((Object)obj);
        return Objects.equals(this.meetingId(), other.meetingId()) && this.hasExcludedAttendeeIds() == other.hasExcludedAttendeeIds() && Objects.equals(this.excludedAttendeeIds(), other.excludedAttendeeIds()) && Objects.equals(this.capabilities(), other.capabilities());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateAttendeeCapabilitiesExceptRequest").add("MeetingId", (Object)this.meetingId()).add("ExcludedAttendeeIds", this.hasExcludedAttendeeIds() ? this.excludedAttendeeIds() : null).add("Capabilities", (Object)this.capabilities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MeetingId": {
                return Optional.ofNullable(clazz.cast(this.meetingId()));
            }
            case "ExcludedAttendeeIds": {
                return Optional.ofNullable(clazz.cast(this.excludedAttendeeIds()));
            }
            case "Capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateAttendeeCapabilitiesExceptRequest, T> g) {
        return obj -> g.apply((BatchUpdateAttendeeCapabilitiesExceptRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMeetingsRequest.BuilderImpl
    implements Builder {
        private String meetingId;
        private List<AttendeeIdItem> excludedAttendeeIds = DefaultSdkAutoConstructList.getInstance();
        private AttendeeCapabilities capabilities;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateAttendeeCapabilitiesExceptRequest model) {
            super(model);
            this.meetingId(model.meetingId);
            this.excludedAttendeeIds(model.excludedAttendeeIds);
            this.capabilities(model.capabilities);
        }

        public final String getMeetingId() {
            return this.meetingId;
        }

        public final void setMeetingId(String meetingId) {
            this.meetingId = meetingId;
        }

        @Override
        public final Builder meetingId(String meetingId) {
            this.meetingId = meetingId;
            return this;
        }

        public final List<AttendeeIdItem.Builder> getExcludedAttendeeIds() {
            List<AttendeeIdItem.Builder> result = AttendeeIdsListCopier.copyToBuilder(this.excludedAttendeeIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludedAttendeeIds(Collection<AttendeeIdItem.BuilderImpl> excludedAttendeeIds) {
            this.excludedAttendeeIds = AttendeeIdsListCopier.copyFromBuilder(excludedAttendeeIds);
        }

        @Override
        public final Builder excludedAttendeeIds(Collection<AttendeeIdItem> excludedAttendeeIds) {
            this.excludedAttendeeIds = AttendeeIdsListCopier.copy(excludedAttendeeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedAttendeeIds(AttendeeIdItem ... excludedAttendeeIds) {
            this.excludedAttendeeIds(Arrays.asList(excludedAttendeeIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedAttendeeIds(Consumer<AttendeeIdItem.Builder> ... excludedAttendeeIds) {
            this.excludedAttendeeIds(Stream.of(excludedAttendeeIds).map(c -> (AttendeeIdItem)((AttendeeIdItem.Builder)AttendeeIdItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AttendeeCapabilities.Builder getCapabilities() {
            return this.capabilities != null ? this.capabilities.toBuilder() : null;
        }

        public final void setCapabilities(AttendeeCapabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(AttendeeCapabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateAttendeeCapabilitiesExceptRequest build() {
            return new BatchUpdateAttendeeCapabilitiesExceptRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeSdkMeetingsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateAttendeeCapabilitiesExceptRequest> {
        public Builder meetingId(String var1);

        public Builder excludedAttendeeIds(Collection<AttendeeIdItem> var1);

        public Builder excludedAttendeeIds(AttendeeIdItem ... var1);

        public Builder excludedAttendeeIds(Consumer<AttendeeIdItem.Builder> ... var1);

        public Builder capabilities(AttendeeCapabilities var1);

        default public Builder capabilities(Consumer<AttendeeCapabilities.Builder> capabilities) {
            return this.capabilities((AttendeeCapabilities)((AttendeeCapabilities.Builder)AttendeeCapabilities.builder().applyMutation(capabilities)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

