/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.ImportDestinationsCopier;
import software.amazon.awssdk.services.cloudtrail.model.ImportSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartImportRequest
extends CloudTrailRequest
implements ToCopyableBuilder<Builder, StartImportRequest> {
    private static final SdkField<List<String>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(StartImportRequest.getter(StartImportRequest::destinations)).setter(StartImportRequest.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ImportSource> IMPORT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImportSource").getter(StartImportRequest.getter(StartImportRequest::importSource)).setter(StartImportRequest.setter(Builder::importSource)).constructor(ImportSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportSource").build()}).build();
    private static final SdkField<Instant> START_EVENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartEventTime").getter(StartImportRequest.getter(StartImportRequest::startEventTime)).setter(StartImportRequest.setter(Builder::startEventTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartEventTime").build()}).build();
    private static final SdkField<Instant> END_EVENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndEventTime").getter(StartImportRequest.getter(StartImportRequest::endEventTime)).setter(StartImportRequest.setter(Builder::endEventTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndEventTime").build()}).build();
    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImportId").getter(StartImportRequest.getter(StartImportRequest::importId)).setter(StartImportRequest.setter(Builder::importId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATIONS_FIELD, IMPORT_SOURCE_FIELD, START_EVENT_TIME_FIELD, END_EVENT_TIME_FIELD, IMPORT_ID_FIELD));
    private final List<String> destinations;
    private final ImportSource importSource;
    private final Instant startEventTime;
    private final Instant endEventTime;
    private final String importId;

    private StartImportRequest(BuilderImpl builder) {
        super(builder);
        this.destinations = builder.destinations;
        this.importSource = builder.importSource;
        this.startEventTime = builder.startEventTime;
        this.endEventTime = builder.endEventTime;
        this.importId = builder.importId;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<String> destinations() {
        return this.destinations;
    }

    public final ImportSource importSource() {
        return this.importSource;
    }

    public final Instant startEventTime() {
        return this.startEventTime;
    }

    public final Instant endEventTime() {
        return this.endEventTime;
    }

    public final String importId() {
        return this.importId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.importSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.startEventTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endEventTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.importId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportRequest)) {
            return false;
        }
        StartImportRequest other = (StartImportRequest)((Object)obj);
        return this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.importSource(), other.importSource()) && Objects.equals(this.startEventTime(), other.startEventTime()) && Objects.equals(this.endEventTime(), other.endEventTime()) && Objects.equals(this.importId(), other.importId());
    }

    public final String toString() {
        return ToString.builder((String)"StartImportRequest").add("Destinations", this.hasDestinations() ? this.destinations() : null).add("ImportSource", (Object)this.importSource()).add("StartEventTime", (Object)this.startEventTime()).add("EndEventTime", (Object)this.endEventTime()).add("ImportId", (Object)this.importId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "ImportSource": {
                return Optional.ofNullable(clazz.cast(this.importSource()));
            }
            case "StartEventTime": {
                return Optional.ofNullable(clazz.cast(this.startEventTime()));
            }
            case "EndEventTime": {
                return Optional.ofNullable(clazz.cast(this.endEventTime()));
            }
            case "ImportId": {
                return Optional.ofNullable(clazz.cast(this.importId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartImportRequest, T> g) {
        return obj -> g.apply((StartImportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailRequest.BuilderImpl
    implements Builder {
        private List<String> destinations = DefaultSdkAutoConstructList.getInstance();
        private ImportSource importSource;
        private Instant startEventTime;
        private Instant endEventTime;
        private String importId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportRequest model) {
            super(model);
            this.destinations(model.destinations);
            this.importSource(model.importSource);
            this.startEventTime(model.startEventTime);
            this.endEventTime(model.endEventTime);
            this.importId(model.importId);
        }

        public final Collection<String> getDestinations() {
            if (this.destinations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destinations;
        }

        public final void setDestinations(Collection<String> destinations) {
            this.destinations = ImportDestinationsCopier.copy(destinations);
        }

        @Override
        public final Builder destinations(Collection<String> destinations) {
            this.destinations = ImportDestinationsCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(String ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        public final ImportSource.Builder getImportSource() {
            return this.importSource != null ? this.importSource.toBuilder() : null;
        }

        public final void setImportSource(ImportSource.BuilderImpl importSource) {
            this.importSource = importSource != null ? importSource.build() : null;
        }

        @Override
        public final Builder importSource(ImportSource importSource) {
            this.importSource = importSource;
            return this;
        }

        public final Instant getStartEventTime() {
            return this.startEventTime;
        }

        public final void setStartEventTime(Instant startEventTime) {
            this.startEventTime = startEventTime;
        }

        @Override
        public final Builder startEventTime(Instant startEventTime) {
            this.startEventTime = startEventTime;
            return this;
        }

        public final Instant getEndEventTime() {
            return this.endEventTime;
        }

        public final void setEndEventTime(Instant endEventTime) {
            this.endEventTime = endEventTime;
        }

        @Override
        public final Builder endEventTime(Instant endEventTime) {
            this.endEventTime = endEventTime;
            return this;
        }

        public final String getImportId() {
            return this.importId;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        @Override
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartImportRequest build() {
            return new StartImportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudTrailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartImportRequest> {
        public Builder destinations(Collection<String> var1);

        public Builder destinations(String ... var1);

        public Builder importSource(ImportSource var1);

        default public Builder importSource(Consumer<ImportSource.Builder> importSource) {
            return this.importSource((ImportSource)((ImportSource.Builder)ImportSource.builder().applyMutation(importSource)).build());
        }

        public Builder startEventTime(Instant var1);

        public Builder endEventTime(Instant var1);

        public Builder importId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

