/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataProtectionPolicyRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, GetDataProtectionPolicyRequest> {
    private static final SdkField<String> LOG_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupIdentifier").getter(GetDataProtectionPolicyRequest.getter(GetDataProtectionPolicyRequest::logGroupIdentifier)).setter(GetDataProtectionPolicyRequest.setter(Builder::logGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_IDENTIFIER_FIELD));
    private final String logGroupIdentifier;

    private GetDataProtectionPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupIdentifier = builder.logGroupIdentifier;
    }

    public final String logGroupIdentifier() {
        return this.logGroupIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataProtectionPolicyRequest)) {
            return false;
        }
        GetDataProtectionPolicyRequest other = (GetDataProtectionPolicyRequest)((Object)obj);
        return Objects.equals(this.logGroupIdentifier(), other.logGroupIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"GetDataProtectionPolicyRequest").add("LogGroupIdentifier", (Object)this.logGroupIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.logGroupIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataProtectionPolicyRequest, T> g) {
        return obj -> g.apply((GetDataProtectionPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String logGroupIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataProtectionPolicyRequest model) {
            super(model);
            this.logGroupIdentifier(model.logGroupIdentifier);
        }

        public final String getLogGroupIdentifier() {
            return this.logGroupIdentifier;
        }

        public final void setLogGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
        }

        @Override
        public final Builder logGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDataProtectionPolicyRequest build() {
            return new GetDataProtectionPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataProtectionPolicyRequest> {
        public Builder logGroupIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

