/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.QueryStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryInfo> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryId").getter(QueryInfo.getter(QueryInfo::queryId)).setter(QueryInfo.setter(Builder::queryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryId").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryString").getter(QueryInfo.getter(QueryInfo::queryString)).setter(QueryInfo.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(QueryInfo.getter(QueryInfo::statusAsString)).setter(QueryInfo.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Long> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("createTime").getter(QueryInfo.getter(QueryInfo::createTime)).setter(QueryInfo.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupName").getter(QueryInfo.getter(QueryInfo::logGroupName)).setter(QueryInfo.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD, QUERY_STRING_FIELD, STATUS_FIELD, CREATE_TIME_FIELD, LOG_GROUP_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String queryId;
    private final String queryString;
    private final String status;
    private final Long createTime;
    private final String logGroupName;

    private QueryInfo(BuilderImpl builder) {
        this.queryId = builder.queryId;
        this.queryString = builder.queryString;
        this.status = builder.status;
        this.createTime = builder.createTime;
        this.logGroupName = builder.logGroupName;
    }

    public final String queryId() {
        return this.queryId;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final QueryStatus status() {
        return QueryStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Long createTime() {
        return this.createTime;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryInfo)) {
            return false;
        }
        QueryInfo other = (QueryInfo)obj;
        return Objects.equals(this.queryId(), other.queryId()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.logGroupName(), other.logGroupName());
    }

    public final String toString() {
        return ToString.builder((String)"QueryInfo").add("QueryId", (Object)this.queryId()).add("QueryString", (Object)this.queryString()).add("Status", (Object)this.statusAsString()).add("CreateTime", (Object)this.createTime()).add("LogGroupName", (Object)this.logGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queryId": {
                return Optional.ofNullable(clazz.cast(this.queryId()));
            }
            case "queryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryInfo, T> g) {
        return obj -> g.apply((QueryInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String queryId;
        private String queryString;
        private String status;
        private Long createTime;
        private String logGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryInfo model) {
            this.queryId(model.queryId);
            this.queryString(model.queryString);
            this.status(model.status);
            this.createTime(model.createTime);
            this.logGroupName(model.logGroupName);
        }

        public final String getQueryId() {
            return this.queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Long getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Long createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public QueryInfo build() {
            return new QueryInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryInfo> {
        public Builder queryId(String var1);

        public Builder queryString(String var1);

        public Builder status(String var1);

        public Builder status(QueryStatus var1);

        public Builder createTime(Long var1);

        public Builder logGroupName(String var1);
    }
}

