/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.token.credentials.aws.DefaultAwsTokenProvider;
import software.amazon.awssdk.auth.token.signer.aws.BearerTokenSigner;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.IdentityProviders;
import software.amazon.awssdk.identity.spi.TokenIdentity;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystBaseClientBuilder;
import software.amazon.awssdk.services.codecatalyst.endpoints.CodeCatalystEndpointProvider;
import software.amazon.awssdk.services.codecatalyst.endpoints.internal.CodeCatalystRequestSetEndpointInterceptor;
import software.amazon.awssdk.services.codecatalyst.endpoints.internal.CodeCatalystResolveEndpointInterceptor;
import software.amazon.awssdk.services.codecatalyst.internal.CodeCatalystServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.codecatalyst.internal.SdkClientConfigurationUtil;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
abstract class DefaultCodeCatalystBaseClientBuilder<B extends CodeCatalystBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    DefaultCodeCatalystBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "codecatalyst";
    }

    protected final String serviceName() {
        return "CodeCatalyst";
    }

    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)this.defaultEndpointProvider()).option((ClientOption)SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, (Object)false).option((ClientOption)AwsClientOption.TOKEN_IDENTITY_PROVIDER, this.defaultTokenProvider()).option((ClientOption)SdkAdvancedClientOption.TOKEN_SIGNER, (Object)this.defaultTokenSigner()));
    }

    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        ArrayList<Object> endpointInterceptors = new ArrayList<Object>();
        endpointInterceptors.add(new CodeCatalystResolveEndpointInterceptor());
        endpointInterceptors.add(new CodeCatalystRequestSetEndpointInterceptor());
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List interceptors = interceptorFactory.getInterceptors("software/amazon/awssdk/services/codecatalyst/execution.interceptors");
        ArrayList additionalInterceptors = new ArrayList();
        interceptors = CollectionUtils.mergeLists(endpointInterceptors, (List)interceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, additionalInterceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, (List)((List)config.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS)));
        SdkClientConfiguration.Builder builder = config.toBuilder();
        IdentityProvider identityProvider = (IdentityProvider)config.option((ClientOption)AwsClientOption.TOKEN_IDENTITY_PROVIDER);
        if (identityProvider != null) {
            IdentityProviders identityProviders = (IdentityProviders)config.option((ClientOption)SdkClientOption.IDENTITY_PROVIDERS);
            builder.option((ClientOption)SdkClientOption.IDENTITY_PROVIDERS, ((IdentityProviders.Builder)identityProviders.toBuilder()).putIdentityProvider(identityProvider).build());
        }
        builder.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors);
        return builder.build();
    }

    protected final String signingName() {
        return "codecatalyst";
    }

    private CodeCatalystEndpointProvider defaultEndpointProvider() {
        return CodeCatalystEndpointProvider.defaultProvider();
    }

    private IdentityProvider<? extends TokenIdentity> defaultTokenProvider() {
        return DefaultAwsTokenProvider.create();
    }

    private Signer defaultTokenSigner() {
        return BearerTokenSigner.create();
    }

    protected SdkClientConfiguration setOverrides(SdkClientConfiguration configuration) {
        ClientOverrideConfiguration overrideConfiguration = this.overrideConfiguration();
        if (overrideConfiguration == null) {
            return configuration;
        }
        return SdkClientConfigurationUtil.copyOverridesToConfiguration(overrideConfiguration, configuration.toBuilder()).build();
    }

    protected SdkClientConfiguration invokePlugins(SdkClientConfiguration config) {
        List plugins = this.plugins();
        if (plugins.isEmpty()) {
            return config;
        }
        CodeCatalystServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = CodeCatalystServiceClientConfigurationBuilder.builder(config.toBuilder());
        serviceConfigBuilder.overrideConfiguration(this.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.overrideConfiguration(serviceConfigBuilder.overrideConfiguration());
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    protected static void validateClientOptions(SdkClientConfiguration c) {
        Validate.notNull((Object)c.option((ClientOption)SdkAdvancedClientOption.TOKEN_SIGNER), (String)"The 'overrideConfiguration.advancedOption[TOKEN_SIGNER]' must be configured in the client builder.", (Object[])new Object[0]);
        Validate.notNull((Object)c.option((ClientOption)AwsClientOption.TOKEN_IDENTITY_PROVIDER), (String)"The 'tokenProvider' must be configured in the client builder.", (Object[])new Object[0]);
    }
}

