/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codepipeline.CodePipelineClient;
import software.amazon.awssdk.services.codepipeline.CodePipelineClientBuilder;
import software.amazon.awssdk.services.codepipeline.CodePipelineServiceClientConfiguration;
import software.amazon.awssdk.services.codepipeline.DefaultCodePipelineBaseClientBuilder;
import software.amazon.awssdk.services.codepipeline.DefaultCodePipelineClient;
import software.amazon.awssdk.services.codepipeline.endpoints.CodePipelineEndpointProvider;

@SdkInternalApi
final class DefaultCodePipelineClientBuilder
extends DefaultCodePipelineBaseClientBuilder<CodePipelineClientBuilder, CodePipelineClient>
implements CodePipelineClientBuilder {
    DefaultCodePipelineClientBuilder() {
    }

    @Override
    public DefaultCodePipelineClientBuilder endpointProvider(CodePipelineEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodePipelineClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCodePipelineClientBuilder.validateClientOptions(clientConfiguration);
        CodePipelineServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCodePipelineClient client = new DefaultCodePipelineClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CodePipelineServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CodePipelineServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

