/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.TriggerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionTrigger
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutionTrigger> {
    private static final SdkField<String> TRIGGER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("triggerType").getter(ExecutionTrigger.getter(ExecutionTrigger::triggerTypeAsString)).setter(ExecutionTrigger.setter(Builder::triggerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerType").build()}).build();
    private static final SdkField<String> TRIGGER_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("triggerDetail").getter(ExecutionTrigger.getter(ExecutionTrigger::triggerDetail)).setter(ExecutionTrigger.setter(Builder::triggerDetail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerDetail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIGGER_TYPE_FIELD, TRIGGER_DETAIL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String triggerType;
    private final String triggerDetail;

    private ExecutionTrigger(BuilderImpl builder) {
        this.triggerType = builder.triggerType;
        this.triggerDetail = builder.triggerDetail;
    }

    public final TriggerType triggerType() {
        return TriggerType.fromValue(this.triggerType);
    }

    public final String triggerTypeAsString() {
        return this.triggerType;
    }

    public final String triggerDetail() {
        return this.triggerDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerDetail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionTrigger)) {
            return false;
        }
        ExecutionTrigger other = (ExecutionTrigger)obj;
        return Objects.equals(this.triggerTypeAsString(), other.triggerTypeAsString()) && Objects.equals(this.triggerDetail(), other.triggerDetail());
    }

    public final String toString() {
        return ToString.builder((String)"ExecutionTrigger").add("TriggerType", (Object)this.triggerTypeAsString()).add("TriggerDetail", (Object)this.triggerDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "triggerType": {
                return Optional.ofNullable(clazz.cast(this.triggerTypeAsString()));
            }
            case "triggerDetail": {
                return Optional.ofNullable(clazz.cast(this.triggerDetail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionTrigger, T> g) {
        return obj -> g.apply((ExecutionTrigger)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String triggerType;
        private String triggerDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionTrigger model) {
            this.triggerType(model.triggerType);
            this.triggerDetail(model.triggerDetail);
        }

        public final String getTriggerType() {
            return this.triggerType;
        }

        public final void setTriggerType(String triggerType) {
            this.triggerType = triggerType;
        }

        @Override
        public final Builder triggerType(String triggerType) {
            this.triggerType = triggerType;
            return this;
        }

        @Override
        public final Builder triggerType(TriggerType triggerType) {
            this.triggerType(triggerType == null ? null : triggerType.toString());
            return this;
        }

        public final String getTriggerDetail() {
            return this.triggerDetail;
        }

        public final void setTriggerDetail(String triggerDetail) {
            this.triggerDetail = triggerDetail;
        }

        @Override
        public final Builder triggerDetail(String triggerDetail) {
            this.triggerDetail = triggerDetail;
            return this;
        }

        public ExecutionTrigger build() {
            return new ExecutionTrigger(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutionTrigger> {
        public Builder triggerType(String var1);

        public Builder triggerType(TriggerType var1);

        public Builder triggerDetail(String var1);
    }
}

