/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codepipeline.CodePipelineClient;
import software.amazon.awssdk.services.codepipeline.internal.UserAgentUtils;
import software.amazon.awssdk.services.codepipeline.model.ListPipelinesRequest;
import software.amazon.awssdk.services.codepipeline.model.ListPipelinesResponse;
import software.amazon.awssdk.services.codepipeline.model.PipelineSummary;

public class ListPipelinesIterable
implements SdkIterable<ListPipelinesResponse> {
    private final CodePipelineClient client;
    private final ListPipelinesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPipelinesIterable(CodePipelineClient client, ListPipelinesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPipelinesResponseFetcher();
    }

    public Iterator<ListPipelinesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PipelineSummary> pipelines() {
        Function<ListPipelinesResponse, Iterator> getIterator = response -> {
            if (response != null && response.pipelines() != null) {
                return response.pipelines().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPipelinesResponseFetcher
    implements SyncPageFetcher<ListPipelinesResponse> {
        private ListPipelinesResponseFetcher() {
        }

        public boolean hasNextPage(ListPipelinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPipelinesResponse nextPage(ListPipelinesResponse previousPage) {
            if (previousPage == null) {
                return ListPipelinesIterable.this.client.listPipelines(ListPipelinesIterable.this.firstRequest);
            }
            return ListPipelinesIterable.this.client.listPipelines((ListPipelinesRequest)((Object)ListPipelinesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

