/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ICD10CMEntityCategory {
    MEDICAL_CONDITION("MEDICAL_CONDITION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ICD10CMEntityCategory> VALUE_MAP;
    private final String value;

    private ICD10CMEntityCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ICD10CMEntityCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ICD10CMEntityCategory> knownValues() {
        EnumSet<ICD10CMEntityCategory> knownValues = EnumSet.allOf(ICD10CMEntityCategory.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ICD10CMEntityCategory.class, ICD10CMEntityCategory::toString);
    }
}

