/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SNOMEDCTAttributeType {
    ACUITY("ACUITY"),
    QUALITY("QUALITY"),
    DIRECTION("DIRECTION"),
    SYSTEM_ORGAN_SITE("SYSTEM_ORGAN_SITE"),
    TEST_VALUE("TEST_VALUE"),
    TEST_UNIT("TEST_UNIT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SNOMEDCTAttributeType> VALUE_MAP;
    private final String value;

    private SNOMEDCTAttributeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SNOMEDCTAttributeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SNOMEDCTAttributeType> knownValues() {
        EnumSet<SNOMEDCTAttributeType> knownValues = EnumSet.allOf(SNOMEDCTAttributeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SNOMEDCTAttributeType.class, SNOMEDCTAttributeType::toString);
    }
}

