/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregationAuthorization
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregationAuthorization> {
    private static final SdkField<String> AGGREGATION_AUTHORIZATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AggregationAuthorizationArn").getter(AggregationAuthorization.getter(AggregationAuthorization::aggregationAuthorizationArn)).setter(AggregationAuthorization.setter(Builder::aggregationAuthorizationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationAuthorizationArn").build()}).build();
    private static final SdkField<String> AUTHORIZED_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthorizedAccountId").getter(AggregationAuthorization.getter(AggregationAuthorization::authorizedAccountId)).setter(AggregationAuthorization.setter(Builder::authorizedAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedAccountId").build()}).build();
    private static final SdkField<String> AUTHORIZED_AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthorizedAwsRegion").getter(AggregationAuthorization.getter(AggregationAuthorization::authorizedAwsRegion)).setter(AggregationAuthorization.setter(Builder::authorizedAwsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedAwsRegion").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(AggregationAuthorization.getter(AggregationAuthorization::creationTime)).setter(AggregationAuthorization.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATION_AUTHORIZATION_ARN_FIELD, AUTHORIZED_ACCOUNT_ID_FIELD, AUTHORIZED_AWS_REGION_FIELD, CREATION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String aggregationAuthorizationArn;
    private final String authorizedAccountId;
    private final String authorizedAwsRegion;
    private final Instant creationTime;

    private AggregationAuthorization(BuilderImpl builder) {
        this.aggregationAuthorizationArn = builder.aggregationAuthorizationArn;
        this.authorizedAccountId = builder.authorizedAccountId;
        this.authorizedAwsRegion = builder.authorizedAwsRegion;
        this.creationTime = builder.creationTime;
    }

    public final String aggregationAuthorizationArn() {
        return this.aggregationAuthorizationArn;
    }

    public final String authorizedAccountId() {
        return this.authorizedAccountId;
    }

    public final String authorizedAwsRegion() {
        return this.authorizedAwsRegion;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationAuthorizationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizedAwsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationAuthorization)) {
            return false;
        }
        AggregationAuthorization other = (AggregationAuthorization)obj;
        return Objects.equals(this.aggregationAuthorizationArn(), other.aggregationAuthorizationArn()) && Objects.equals(this.authorizedAccountId(), other.authorizedAccountId()) && Objects.equals(this.authorizedAwsRegion(), other.authorizedAwsRegion()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"AggregationAuthorization").add("AggregationAuthorizationArn", (Object)this.aggregationAuthorizationArn()).add("AuthorizedAccountId", (Object)this.authorizedAccountId()).add("AuthorizedAwsRegion", (Object)this.authorizedAwsRegion()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AggregationAuthorizationArn": {
                return Optional.ofNullable(clazz.cast(this.aggregationAuthorizationArn()));
            }
            case "AuthorizedAccountId": {
                return Optional.ofNullable(clazz.cast(this.authorizedAccountId()));
            }
            case "AuthorizedAwsRegion": {
                return Optional.ofNullable(clazz.cast(this.authorizedAwsRegion()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregationAuthorization, T> g) {
        return obj -> g.apply((AggregationAuthorization)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String aggregationAuthorizationArn;
        private String authorizedAccountId;
        private String authorizedAwsRegion;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregationAuthorization model) {
            this.aggregationAuthorizationArn(model.aggregationAuthorizationArn);
            this.authorizedAccountId(model.authorizedAccountId);
            this.authorizedAwsRegion(model.authorizedAwsRegion);
            this.creationTime(model.creationTime);
        }

        public final String getAggregationAuthorizationArn() {
            return this.aggregationAuthorizationArn;
        }

        public final void setAggregationAuthorizationArn(String aggregationAuthorizationArn) {
            this.aggregationAuthorizationArn = aggregationAuthorizationArn;
        }

        @Override
        public final Builder aggregationAuthorizationArn(String aggregationAuthorizationArn) {
            this.aggregationAuthorizationArn = aggregationAuthorizationArn;
            return this;
        }

        public final String getAuthorizedAccountId() {
            return this.authorizedAccountId;
        }

        public final void setAuthorizedAccountId(String authorizedAccountId) {
            this.authorizedAccountId = authorizedAccountId;
        }

        @Override
        public final Builder authorizedAccountId(String authorizedAccountId) {
            this.authorizedAccountId = authorizedAccountId;
            return this;
        }

        public final String getAuthorizedAwsRegion() {
            return this.authorizedAwsRegion;
        }

        public final void setAuthorizedAwsRegion(String authorizedAwsRegion) {
            this.authorizedAwsRegion = authorizedAwsRegion;
        }

        @Override
        public final Builder authorizedAwsRegion(String authorizedAwsRegion) {
            this.authorizedAwsRegion = authorizedAwsRegion;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public AggregationAuthorization build() {
            return new AggregationAuthorization(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregationAuthorization> {
        public Builder aggregationAuthorizationArn(String var1);

        public Builder authorizedAccountId(String var1);

        public Builder authorizedAwsRegion(String var1);

        public Builder creationTime(Instant var1);
    }
}

