/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.AgentInfo;
import software.amazon.awssdk.services.connect.model.Channel;
import software.amazon.awssdk.services.connect.model.ContactInitiationMethod;
import software.amazon.awssdk.services.connect.model.QueueInfo;
import software.amazon.awssdk.services.connect.model.WisdomInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Contact
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Contact> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Contact.getter(Contact::arn)).setter(Contact.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Contact.getter(Contact::id)).setter(Contact.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> INITIAL_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitialContactId").getter(Contact.getter(Contact::initialContactId)).setter(Contact.setter(Builder::initialContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialContactId").build()}).build();
    private static final SdkField<String> PREVIOUS_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreviousContactId").getter(Contact.getter(Contact::previousContactId)).setter(Contact.setter(Builder::previousContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousContactId").build()}).build();
    private static final SdkField<String> INITIATION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitiationMethod").getter(Contact.getter(Contact::initiationMethodAsString)).setter(Contact.setter(Builder::initiationMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationMethod").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Contact.getter(Contact::name)).setter(Contact.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Contact.getter(Contact::description)).setter(Contact.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Channel").getter(Contact.getter(Contact::channelAsString)).setter(Contact.setter(Builder::channel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()}).build();
    private static final SdkField<QueueInfo> QUEUE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueueInfo").getter(Contact.getter(Contact::queueInfo)).setter(Contact.setter(Builder::queueInfo)).constructor(QueueInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueInfo").build()}).build();
    private static final SdkField<AgentInfo> AGENT_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AgentInfo").getter(Contact.getter(Contact::agentInfo)).setter(Contact.setter(Builder::agentInfo)).constructor(AgentInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentInfo").build()}).build();
    private static final SdkField<Instant> INITIATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InitiationTimestamp").getter(Contact.getter(Contact::initiationTimestamp)).setter(Contact.setter(Builder::initiationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationTimestamp").build()}).build();
    private static final SdkField<Instant> DISCONNECT_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DisconnectTimestamp").getter(Contact.getter(Contact::disconnectTimestamp)).setter(Contact.setter(Builder::disconnectTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateTimestamp").getter(Contact.getter(Contact::lastUpdateTimestamp)).setter(Contact.setter(Builder::lastUpdateTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimestamp").build()}).build();
    private static final SdkField<Instant> SCHEDULED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScheduledTimestamp").getter(Contact.getter(Contact::scheduledTimestamp)).setter(Contact.setter(Builder::scheduledTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledTimestamp").build()}).build();
    private static final SdkField<String> RELATED_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelatedContactId").getter(Contact.getter(Contact::relatedContactId)).setter(Contact.setter(Builder::relatedContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedContactId").build()}).build();
    private static final SdkField<WisdomInfo> WISDOM_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WisdomInfo").getter(Contact.getter(Contact::wisdomInfo)).setter(Contact.setter(Builder::wisdomInfo)).constructor(WisdomInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WisdomInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, INITIAL_CONTACT_ID_FIELD, PREVIOUS_CONTACT_ID_FIELD, INITIATION_METHOD_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CHANNEL_FIELD, QUEUE_INFO_FIELD, AGENT_INFO_FIELD, INITIATION_TIMESTAMP_FIELD, DISCONNECT_TIMESTAMP_FIELD, LAST_UPDATE_TIMESTAMP_FIELD, SCHEDULED_TIMESTAMP_FIELD, RELATED_CONTACT_ID_FIELD, WISDOM_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String id;
    private final String initialContactId;
    private final String previousContactId;
    private final String initiationMethod;
    private final String name;
    private final String description;
    private final String channel;
    private final QueueInfo queueInfo;
    private final AgentInfo agentInfo;
    private final Instant initiationTimestamp;
    private final Instant disconnectTimestamp;
    private final Instant lastUpdateTimestamp;
    private final Instant scheduledTimestamp;
    private final String relatedContactId;
    private final WisdomInfo wisdomInfo;

    private Contact(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.initialContactId = builder.initialContactId;
        this.previousContactId = builder.previousContactId;
        this.initiationMethod = builder.initiationMethod;
        this.name = builder.name;
        this.description = builder.description;
        this.channel = builder.channel;
        this.queueInfo = builder.queueInfo;
        this.agentInfo = builder.agentInfo;
        this.initiationTimestamp = builder.initiationTimestamp;
        this.disconnectTimestamp = builder.disconnectTimestamp;
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
        this.scheduledTimestamp = builder.scheduledTimestamp;
        this.relatedContactId = builder.relatedContactId;
        this.wisdomInfo = builder.wisdomInfo;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String initialContactId() {
        return this.initialContactId;
    }

    public final String previousContactId() {
        return this.previousContactId;
    }

    public final ContactInitiationMethod initiationMethod() {
        return ContactInitiationMethod.fromValue(this.initiationMethod);
    }

    public final String initiationMethodAsString() {
        return this.initiationMethod;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Channel channel() {
        return Channel.fromValue(this.channel);
    }

    public final String channelAsString() {
        return this.channel;
    }

    public final QueueInfo queueInfo() {
        return this.queueInfo;
    }

    public final AgentInfo agentInfo() {
        return this.agentInfo;
    }

    public final Instant initiationTimestamp() {
        return this.initiationTimestamp;
    }

    public final Instant disconnectTimestamp() {
        return this.disconnectTimestamp;
    }

    public final Instant lastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public final Instant scheduledTimestamp() {
        return this.scheduledTimestamp;
    }

    public final String relatedContactId() {
        return this.relatedContactId;
    }

    public final WisdomInfo wisdomInfo() {
        return this.wisdomInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiationMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.disconnectTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.wisdomInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Contact)) {
            return false;
        }
        Contact other = (Contact)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.initialContactId(), other.initialContactId()) && Objects.equals(this.previousContactId(), other.previousContactId()) && Objects.equals(this.initiationMethodAsString(), other.initiationMethodAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.channelAsString(), other.channelAsString()) && Objects.equals(this.queueInfo(), other.queueInfo()) && Objects.equals(this.agentInfo(), other.agentInfo()) && Objects.equals(this.initiationTimestamp(), other.initiationTimestamp()) && Objects.equals(this.disconnectTimestamp(), other.disconnectTimestamp()) && Objects.equals(this.lastUpdateTimestamp(), other.lastUpdateTimestamp()) && Objects.equals(this.scheduledTimestamp(), other.scheduledTimestamp()) && Objects.equals(this.relatedContactId(), other.relatedContactId()) && Objects.equals(this.wisdomInfo(), other.wisdomInfo());
    }

    public final String toString() {
        return ToString.builder((String)"Contact").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("InitialContactId", (Object)this.initialContactId()).add("PreviousContactId", (Object)this.previousContactId()).add("InitiationMethod", (Object)this.initiationMethodAsString()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Channel", (Object)this.channelAsString()).add("QueueInfo", (Object)this.queueInfo()).add("AgentInfo", (Object)this.agentInfo()).add("InitiationTimestamp", (Object)this.initiationTimestamp()).add("DisconnectTimestamp", (Object)this.disconnectTimestamp()).add("LastUpdateTimestamp", (Object)this.lastUpdateTimestamp()).add("ScheduledTimestamp", (Object)this.scheduledTimestamp()).add("RelatedContactId", (Object)this.relatedContactId()).add("WisdomInfo", (Object)this.wisdomInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "InitialContactId": {
                return Optional.ofNullable(clazz.cast(this.initialContactId()));
            }
            case "PreviousContactId": {
                return Optional.ofNullable(clazz.cast(this.previousContactId()));
            }
            case "InitiationMethod": {
                return Optional.ofNullable(clazz.cast(this.initiationMethodAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Channel": {
                return Optional.ofNullable(clazz.cast(this.channelAsString()));
            }
            case "QueueInfo": {
                return Optional.ofNullable(clazz.cast(this.queueInfo()));
            }
            case "AgentInfo": {
                return Optional.ofNullable(clazz.cast(this.agentInfo()));
            }
            case "InitiationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.initiationTimestamp()));
            }
            case "DisconnectTimestamp": {
                return Optional.ofNullable(clazz.cast(this.disconnectTimestamp()));
            }
            case "LastUpdateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTimestamp()));
            }
            case "ScheduledTimestamp": {
                return Optional.ofNullable(clazz.cast(this.scheduledTimestamp()));
            }
            case "RelatedContactId": {
                return Optional.ofNullable(clazz.cast(this.relatedContactId()));
            }
            case "WisdomInfo": {
                return Optional.ofNullable(clazz.cast(this.wisdomInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Contact, T> g) {
        return obj -> g.apply((Contact)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String initialContactId;
        private String previousContactId;
        private String initiationMethod;
        private String name;
        private String description;
        private String channel;
        private QueueInfo queueInfo;
        private AgentInfo agentInfo;
        private Instant initiationTimestamp;
        private Instant disconnectTimestamp;
        private Instant lastUpdateTimestamp;
        private Instant scheduledTimestamp;
        private String relatedContactId;
        private WisdomInfo wisdomInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(Contact model) {
            this.arn(model.arn);
            this.id(model.id);
            this.initialContactId(model.initialContactId);
            this.previousContactId(model.previousContactId);
            this.initiationMethod(model.initiationMethod);
            this.name(model.name);
            this.description(model.description);
            this.channel(model.channel);
            this.queueInfo(model.queueInfo);
            this.agentInfo(model.agentInfo);
            this.initiationTimestamp(model.initiationTimestamp);
            this.disconnectTimestamp(model.disconnectTimestamp);
            this.lastUpdateTimestamp(model.lastUpdateTimestamp);
            this.scheduledTimestamp(model.scheduledTimestamp);
            this.relatedContactId(model.relatedContactId);
            this.wisdomInfo(model.wisdomInfo);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getInitialContactId() {
            return this.initialContactId;
        }

        public final void setInitialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
        }

        @Override
        public final Builder initialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
            return this;
        }

        public final String getPreviousContactId() {
            return this.previousContactId;
        }

        public final void setPreviousContactId(String previousContactId) {
            this.previousContactId = previousContactId;
        }

        @Override
        public final Builder previousContactId(String previousContactId) {
            this.previousContactId = previousContactId;
            return this;
        }

        public final String getInitiationMethod() {
            return this.initiationMethod;
        }

        public final void setInitiationMethod(String initiationMethod) {
            this.initiationMethod = initiationMethod;
        }

        @Override
        public final Builder initiationMethod(String initiationMethod) {
            this.initiationMethod = initiationMethod;
            return this;
        }

        @Override
        public final Builder initiationMethod(ContactInitiationMethod initiationMethod) {
            this.initiationMethod(initiationMethod == null ? null : initiationMethod.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getChannel() {
            return this.channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public final QueueInfo.Builder getQueueInfo() {
            return this.queueInfo != null ? this.queueInfo.toBuilder() : null;
        }

        public final void setQueueInfo(QueueInfo.BuilderImpl queueInfo) {
            this.queueInfo = queueInfo != null ? queueInfo.build() : null;
        }

        @Override
        public final Builder queueInfo(QueueInfo queueInfo) {
            this.queueInfo = queueInfo;
            return this;
        }

        public final AgentInfo.Builder getAgentInfo() {
            return this.agentInfo != null ? this.agentInfo.toBuilder() : null;
        }

        public final void setAgentInfo(AgentInfo.BuilderImpl agentInfo) {
            this.agentInfo = agentInfo != null ? agentInfo.build() : null;
        }

        @Override
        public final Builder agentInfo(AgentInfo agentInfo) {
            this.agentInfo = agentInfo;
            return this;
        }

        public final Instant getInitiationTimestamp() {
            return this.initiationTimestamp;
        }

        public final void setInitiationTimestamp(Instant initiationTimestamp) {
            this.initiationTimestamp = initiationTimestamp;
        }

        @Override
        public final Builder initiationTimestamp(Instant initiationTimestamp) {
            this.initiationTimestamp = initiationTimestamp;
            return this;
        }

        public final Instant getDisconnectTimestamp() {
            return this.disconnectTimestamp;
        }

        public final void setDisconnectTimestamp(Instant disconnectTimestamp) {
            this.disconnectTimestamp = disconnectTimestamp;
        }

        @Override
        public final Builder disconnectTimestamp(Instant disconnectTimestamp) {
            this.disconnectTimestamp = disconnectTimestamp;
            return this;
        }

        public final Instant getLastUpdateTimestamp() {
            return this.lastUpdateTimestamp;
        }

        public final void setLastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
        }

        @Override
        public final Builder lastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public final Instant getScheduledTimestamp() {
            return this.scheduledTimestamp;
        }

        public final void setScheduledTimestamp(Instant scheduledTimestamp) {
            this.scheduledTimestamp = scheduledTimestamp;
        }

        @Override
        public final Builder scheduledTimestamp(Instant scheduledTimestamp) {
            this.scheduledTimestamp = scheduledTimestamp;
            return this;
        }

        public final String getRelatedContactId() {
            return this.relatedContactId;
        }

        public final void setRelatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
        }

        @Override
        public final Builder relatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
            return this;
        }

        public final WisdomInfo.Builder getWisdomInfo() {
            return this.wisdomInfo != null ? this.wisdomInfo.toBuilder() : null;
        }

        public final void setWisdomInfo(WisdomInfo.BuilderImpl wisdomInfo) {
            this.wisdomInfo = wisdomInfo != null ? wisdomInfo.build() : null;
        }

        @Override
        public final Builder wisdomInfo(WisdomInfo wisdomInfo) {
            this.wisdomInfo = wisdomInfo;
            return this;
        }

        public Contact build() {
            return new Contact(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Contact> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder initialContactId(String var1);

        public Builder previousContactId(String var1);

        public Builder initiationMethod(String var1);

        public Builder initiationMethod(ContactInitiationMethod var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder channel(String var1);

        public Builder channel(Channel var1);

        public Builder queueInfo(QueueInfo var1);

        default public Builder queueInfo(Consumer<QueueInfo.Builder> queueInfo) {
            return this.queueInfo((QueueInfo)((QueueInfo.Builder)QueueInfo.builder().applyMutation(queueInfo)).build());
        }

        public Builder agentInfo(AgentInfo var1);

        default public Builder agentInfo(Consumer<AgentInfo.Builder> agentInfo) {
            return this.agentInfo((AgentInfo)((AgentInfo.Builder)AgentInfo.builder().applyMutation(agentInfo)).build());
        }

        public Builder initiationTimestamp(Instant var1);

        public Builder disconnectTimestamp(Instant var1);

        public Builder lastUpdateTimestamp(Instant var1);

        public Builder scheduledTimestamp(Instant var1);

        public Builder relatedContactId(String var1);

        public Builder wisdomInfo(WisdomInfo var1);

        default public Builder wisdomInfo(Consumer<WisdomInfo.Builder> wisdomInfo) {
            return this.wisdomInfo((WisdomInfo)((WisdomInfo.Builder)WisdomInfo.builder().applyMutation(wisdomInfo)).build());
        }
    }
}

