/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.QuickConnect;
import software.amazon.awssdk.services.connect.model.QuickConnectSearchSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchQuickConnectsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, SearchQuickConnectsResponse> {
    private static final SdkField<List<QuickConnect>> QUICK_CONNECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QuickConnects").getter(SearchQuickConnectsResponse.getter(SearchQuickConnectsResponse::quickConnects)).setter(SearchQuickConnectsResponse.setter(Builder::quickConnects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnects").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QuickConnect::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchQuickConnectsResponse.getter(SearchQuickConnectsResponse::nextToken)).setter(SearchQuickConnectsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Long> APPROXIMATE_TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApproximateTotalCount").getter(SearchQuickConnectsResponse.getter(SearchQuickConnectsResponse::approximateTotalCount)).setter(SearchQuickConnectsResponse.setter(Builder::approximateTotalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateTotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUICK_CONNECTS_FIELD, NEXT_TOKEN_FIELD, APPROXIMATE_TOTAL_COUNT_FIELD));
    private final List<QuickConnect> quickConnects;
    private final String nextToken;
    private final Long approximateTotalCount;

    private SearchQuickConnectsResponse(BuilderImpl builder) {
        super(builder);
        this.quickConnects = builder.quickConnects;
        this.nextToken = builder.nextToken;
        this.approximateTotalCount = builder.approximateTotalCount;
    }

    public final boolean hasQuickConnects() {
        return this.quickConnects != null && !(this.quickConnects instanceof SdkAutoConstructList);
    }

    public final List<QuickConnect> quickConnects() {
        return this.quickConnects;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Long approximateTotalCount() {
        return this.approximateTotalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQuickConnects() ? this.quickConnects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateTotalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchQuickConnectsResponse)) {
            return false;
        }
        SearchQuickConnectsResponse other = (SearchQuickConnectsResponse)((Object)obj);
        return this.hasQuickConnects() == other.hasQuickConnects() && Objects.equals(this.quickConnects(), other.quickConnects()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.approximateTotalCount(), other.approximateTotalCount());
    }

    public final String toString() {
        return ToString.builder((String)"SearchQuickConnectsResponse").add("QuickConnects", this.hasQuickConnects() ? this.quickConnects() : null).add("NextToken", (Object)this.nextToken()).add("ApproximateTotalCount", (Object)this.approximateTotalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QuickConnects": {
                return Optional.ofNullable(clazz.cast(this.quickConnects()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ApproximateTotalCount": {
                return Optional.ofNullable(clazz.cast(this.approximateTotalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchQuickConnectsResponse, T> g) {
        return obj -> g.apply((SearchQuickConnectsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<QuickConnect> quickConnects = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Long approximateTotalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchQuickConnectsResponse model) {
            super(model);
            this.quickConnects(model.quickConnects);
            this.nextToken(model.nextToken);
            this.approximateTotalCount(model.approximateTotalCount);
        }

        public final List<QuickConnect.Builder> getQuickConnects() {
            List<QuickConnect.Builder> result = QuickConnectSearchSummaryListCopier.copyToBuilder(this.quickConnects);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQuickConnects(Collection<QuickConnect.BuilderImpl> quickConnects) {
            this.quickConnects = QuickConnectSearchSummaryListCopier.copyFromBuilder(quickConnects);
        }

        @Override
        public final Builder quickConnects(Collection<QuickConnect> quickConnects) {
            this.quickConnects = QuickConnectSearchSummaryListCopier.copy(quickConnects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quickConnects(QuickConnect ... quickConnects) {
            this.quickConnects(Arrays.asList(quickConnects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quickConnects(Consumer<QuickConnect.Builder> ... quickConnects) {
            this.quickConnects(Stream.of(quickConnects).map(c -> (QuickConnect)((QuickConnect.Builder)QuickConnect.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getApproximateTotalCount() {
            return this.approximateTotalCount;
        }

        public final void setApproximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
        }

        @Override
        public final Builder approximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
            return this;
        }

        @Override
        public SearchQuickConnectsResponse build() {
            return new SearchQuickConnectsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchQuickConnectsResponse> {
        public Builder quickConnects(Collection<QuickConnect> var1);

        public Builder quickConnects(QuickConnect ... var1);

        public Builder quickConnects(Consumer<QuickConnect.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder approximateTotalCount(Long var1);
    }
}

