/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePhoneNumberMetadataRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdatePhoneNumberMetadataRequest> {
    private static final SdkField<String> PHONE_NUMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumberId").getter(UpdatePhoneNumberMetadataRequest.getter(UpdatePhoneNumberMetadataRequest::phoneNumberId)).setter(UpdatePhoneNumberMetadataRequest.setter(Builder::phoneNumberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("PhoneNumberId").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumberDescription").getter(UpdatePhoneNumberMetadataRequest.getter(UpdatePhoneNumberMetadataRequest::phoneNumberDescription)).setter(UpdatePhoneNumberMetadataRequest.setter(Builder::phoneNumberDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberDescription").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(UpdatePhoneNumberMetadataRequest.getter(UpdatePhoneNumberMetadataRequest::clientToken)).setter(UpdatePhoneNumberMetadataRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ID_FIELD, PHONE_NUMBER_DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD));
    private final String phoneNumberId;
    private final String phoneNumberDescription;
    private final String clientToken;

    private UpdatePhoneNumberMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.phoneNumberId = builder.phoneNumberId;
        this.phoneNumberDescription = builder.phoneNumberDescription;
        this.clientToken = builder.clientToken;
    }

    public final String phoneNumberId() {
        return this.phoneNumberId;
    }

    public final String phoneNumberDescription() {
        return this.phoneNumberDescription;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePhoneNumberMetadataRequest)) {
            return false;
        }
        UpdatePhoneNumberMetadataRequest other = (UpdatePhoneNumberMetadataRequest)((Object)obj);
        return Objects.equals(this.phoneNumberId(), other.phoneNumberId()) && Objects.equals(this.phoneNumberDescription(), other.phoneNumberDescription()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePhoneNumberMetadataRequest").add("PhoneNumberId", (Object)this.phoneNumberId()).add("PhoneNumberDescription", (Object)this.phoneNumberDescription()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneNumberId": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberId()));
            }
            case "PhoneNumberDescription": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberDescription()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePhoneNumberMetadataRequest, T> g) {
        return obj -> g.apply((UpdatePhoneNumberMetadataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String phoneNumberId;
        private String phoneNumberDescription;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePhoneNumberMetadataRequest model) {
            super(model);
            this.phoneNumberId(model.phoneNumberId);
            this.phoneNumberDescription(model.phoneNumberDescription);
            this.clientToken(model.clientToken);
        }

        public final String getPhoneNumberId() {
            return this.phoneNumberId;
        }

        public final void setPhoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
        }

        @Override
        public final Builder phoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
            return this;
        }

        public final String getPhoneNumberDescription() {
            return this.phoneNumberDescription;
        }

        public final void setPhoneNumberDescription(String phoneNumberDescription) {
            this.phoneNumberDescription = phoneNumberDescription;
        }

        @Override
        public final Builder phoneNumberDescription(String phoneNumberDescription) {
            this.phoneNumberDescription = phoneNumberDescription;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePhoneNumberMetadataRequest build() {
            return new UpdatePhoneNumberMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePhoneNumberMetadataRequest> {
        public Builder phoneNumberId(String var1);

        public Builder phoneNumberDescription(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

