/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersResponse;
import software.amazon.awssdk.services.connect.model.PhoneNumberSummary;

public class ListPhoneNumbersPublisher
implements SdkPublisher<ListPhoneNumbersResponse> {
    private final ConnectAsyncClient client;
    private final ListPhoneNumbersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPhoneNumbersPublisher(ConnectAsyncClient client, ListPhoneNumbersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPhoneNumbersPublisher(ConnectAsyncClient client, ListPhoneNumbersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPhoneNumbersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPhoneNumbersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PhoneNumberSummary> phoneNumberSummaryList() {
        Function<ListPhoneNumbersResponse, Iterator> getIterator = response -> {
            if (response != null && response.phoneNumberSummaryList() != null) {
                return response.phoneNumberSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPhoneNumbersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPhoneNumbersResponseFetcher
    implements AsyncPageFetcher<ListPhoneNumbersResponse> {
        private ListPhoneNumbersResponseFetcher() {
        }

        public boolean hasNextPage(ListPhoneNumbersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPhoneNumbersResponse> nextPage(ListPhoneNumbersResponse previousPage) {
            if (previousPage == null) {
                return ListPhoneNumbersPublisher.this.client.listPhoneNumbers(ListPhoneNumbersPublisher.this.firstRequest);
            }
            return ListPhoneNumbersPublisher.this.client.listPhoneNumbers((ListPhoneNumbersRequest)((Object)ListPhoneNumbersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

