/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.connectparticipant.ConnectParticipantClient;
import software.amazon.awssdk.services.connectparticipant.ConnectParticipantClientBuilder;
import software.amazon.awssdk.services.connectparticipant.ConnectParticipantServiceClientConfiguration;
import software.amazon.awssdk.services.connectparticipant.DefaultConnectParticipantBaseClientBuilder;
import software.amazon.awssdk.services.connectparticipant.DefaultConnectParticipantClient;
import software.amazon.awssdk.services.connectparticipant.endpoints.ConnectParticipantEndpointProvider;

@SdkInternalApi
final class DefaultConnectParticipantClientBuilder
extends DefaultConnectParticipantBaseClientBuilder<ConnectParticipantClientBuilder, ConnectParticipantClient>
implements ConnectParticipantClientBuilder {
    DefaultConnectParticipantClientBuilder() {
    }

    @Override
    public DefaultConnectParticipantClientBuilder endpointProvider(ConnectParticipantEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ConnectParticipantClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultConnectParticipantClientBuilder.validateClientOptions(clientConfiguration);
        ConnectParticipantServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultConnectParticipantClient client = new DefaultConnectParticipantClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ConnectParticipantServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ConnectParticipantServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

