/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesAsyncClient;
import software.amazon.awssdk.services.customerprofiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.customerprofiles.model.EventStreamSummary;
import software.amazon.awssdk.services.customerprofiles.model.ListEventStreamsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListEventStreamsResponse;

public class ListEventStreamsPublisher
implements SdkPublisher<ListEventStreamsResponse> {
    private final CustomerProfilesAsyncClient client;
    private final ListEventStreamsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEventStreamsPublisher(CustomerProfilesAsyncClient client, ListEventStreamsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEventStreamsPublisher(CustomerProfilesAsyncClient client, ListEventStreamsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEventStreamsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEventStreamsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EventStreamSummary> items() {
        Function<ListEventStreamsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEventStreamsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEventStreamsResponseFetcher
    implements AsyncPageFetcher<ListEventStreamsResponse> {
        private ListEventStreamsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventStreamsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEventStreamsResponse> nextPage(ListEventStreamsResponse previousPage) {
            if (previousPage == null) {
                return ListEventStreamsPublisher.this.client.listEventStreams(ListEventStreamsPublisher.this.firstRequest);
            }
            return ListEventStreamsPublisher.this.client.listEventStreams((ListEventStreamsRequest)((Object)ListEventStreamsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

