/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.SchemaConversionRequest;
import software.amazon.awssdk.services.databasemigration.model.SchemaConversionRequestListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMetadataModelAssessmentsResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeMetadataModelAssessmentsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeMetadataModelAssessmentsResponse.getter(DescribeMetadataModelAssessmentsResponse::marker)).setter(DescribeMetadataModelAssessmentsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<SchemaConversionRequest>> REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Requests").getter(DescribeMetadataModelAssessmentsResponse.getter(DescribeMetadataModelAssessmentsResponse::requests)).setter(DescribeMetadataModelAssessmentsResponse.setter(Builder::requests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Requests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SchemaConversionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, REQUESTS_FIELD));
    private final String marker;
    private final List<SchemaConversionRequest> requests;

    private DescribeMetadataModelAssessmentsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.requests = builder.requests;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasRequests() {
        return this.requests != null && !(this.requests instanceof SdkAutoConstructList);
    }

    public final List<SchemaConversionRequest> requests() {
        return this.requests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequests() ? this.requests() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetadataModelAssessmentsResponse)) {
            return false;
        }
        DescribeMetadataModelAssessmentsResponse other = (DescribeMetadataModelAssessmentsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasRequests() == other.hasRequests() && Objects.equals(this.requests(), other.requests());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMetadataModelAssessmentsResponse").add("Marker", (Object)this.marker()).add("Requests", this.hasRequests() ? this.requests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "Requests": {
                return Optional.ofNullable(clazz.cast(this.requests()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMetadataModelAssessmentsResponse, T> g) {
        return obj -> g.apply((DescribeMetadataModelAssessmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<SchemaConversionRequest> requests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMetadataModelAssessmentsResponse model) {
            super(model);
            this.marker(model.marker);
            this.requests(model.requests);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<SchemaConversionRequest.Builder> getRequests() {
            List<SchemaConversionRequest.Builder> result = SchemaConversionRequestListCopier.copyToBuilder(this.requests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRequests(Collection<SchemaConversionRequest.BuilderImpl> requests) {
            this.requests = SchemaConversionRequestListCopier.copyFromBuilder(requests);
        }

        @Override
        public final Builder requests(Collection<SchemaConversionRequest> requests) {
            this.requests = SchemaConversionRequestListCopier.copy(requests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requests(SchemaConversionRequest ... requests) {
            this.requests(Arrays.asList(requests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requests(Consumer<SchemaConversionRequest.Builder> ... requests) {
            this.requests(Stream.of(requests).map(c -> (SchemaConversionRequest)((SchemaConversionRequest.Builder)SchemaConversionRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeMetadataModelAssessmentsResponse build() {
            return new DescribeMetadataModelAssessmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMetadataModelAssessmentsResponse> {
        public Builder marker(String var1);

        public Builder requests(Collection<SchemaConversionRequest> var1);

        public Builder requests(SchemaConversionRequest ... var1);

        public Builder requests(Consumer<SchemaConversionRequest.Builder> ... var1);
    }
}

