/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.ReplicationConfig;
import software.amazon.awssdk.services.databasemigration.model.ReplicationConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReplicationConfigsResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeReplicationConfigsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeReplicationConfigsResponse.getter(DescribeReplicationConfigsResponse::marker)).setter(DescribeReplicationConfigsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<ReplicationConfig>> REPLICATION_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicationConfigs").getter(DescribeReplicationConfigsResponse.getter(DescribeReplicationConfigsResponse::replicationConfigs)).setter(DescribeReplicationConfigsResponse.setter(Builder::replicationConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, REPLICATION_CONFIGS_FIELD));
    private final String marker;
    private final List<ReplicationConfig> replicationConfigs;

    private DescribeReplicationConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.replicationConfigs = builder.replicationConfigs;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasReplicationConfigs() {
        return this.replicationConfigs != null && !(this.replicationConfigs instanceof SdkAutoConstructList);
    }

    public final List<ReplicationConfig> replicationConfigs() {
        return this.replicationConfigs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationConfigs() ? this.replicationConfigs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationConfigsResponse)) {
            return false;
        }
        DescribeReplicationConfigsResponse other = (DescribeReplicationConfigsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasReplicationConfigs() == other.hasReplicationConfigs() && Objects.equals(this.replicationConfigs(), other.replicationConfigs());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReplicationConfigsResponse").add("Marker", (Object)this.marker()).add("ReplicationConfigs", this.hasReplicationConfigs() ? this.replicationConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ReplicationConfigs": {
                return Optional.ofNullable(clazz.cast(this.replicationConfigs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationConfigsResponse, T> g) {
        return obj -> g.apply((DescribeReplicationConfigsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ReplicationConfig> replicationConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationConfigsResponse model) {
            super(model);
            this.marker(model.marker);
            this.replicationConfigs(model.replicationConfigs);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<ReplicationConfig.Builder> getReplicationConfigs() {
            List<ReplicationConfig.Builder> result = ReplicationConfigListCopier.copyToBuilder(this.replicationConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationConfigs(Collection<ReplicationConfig.BuilderImpl> replicationConfigs) {
            this.replicationConfigs = ReplicationConfigListCopier.copyFromBuilder(replicationConfigs);
        }

        @Override
        public final Builder replicationConfigs(Collection<ReplicationConfig> replicationConfigs) {
            this.replicationConfigs = ReplicationConfigListCopier.copy(replicationConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationConfigs(ReplicationConfig ... replicationConfigs) {
            this.replicationConfigs(Arrays.asList(replicationConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationConfigs(Consumer<ReplicationConfig.Builder> ... replicationConfigs) {
            this.replicationConfigs(Stream.of(replicationConfigs).map(c -> (ReplicationConfig)((ReplicationConfig.Builder)ReplicationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReplicationConfigsResponse build() {
            return new DescribeReplicationConfigsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReplicationConfigsResponse> {
        public Builder marker(String var1);

        public Builder replicationConfigs(Collection<ReplicationConfig> var1);

        public Builder replicationConfigs(ReplicationConfig ... var1);

        public Builder replicationConfigs(Consumer<ReplicationConfig.Builder> ... var1);
    }
}

