/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.KafkaSaslMechanism;
import software.amazon.awssdk.services.databasemigration.model.KafkaSecurityProtocol;
import software.amazon.awssdk.services.databasemigration.model.KafkaSslEndpointIdentificationAlgorithm;
import software.amazon.awssdk.services.databasemigration.model.MessageFormatValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KafkaSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KafkaSettings> {
    private static final SdkField<String> BROKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Broker").getter(KafkaSettings.getter(KafkaSettings::broker)).setter(KafkaSettings.setter(Builder::broker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Broker").build()}).build();
    private static final SdkField<String> TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Topic").getter(KafkaSettings.getter(KafkaSettings::topic)).setter(KafkaSettings.setter(Builder::topic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Topic").build()}).build();
    private static final SdkField<String> MESSAGE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageFormat").getter(KafkaSettings.getter(KafkaSettings::messageFormatAsString)).setter(KafkaSettings.setter(Builder::messageFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageFormat").build()}).build();
    private static final SdkField<Boolean> INCLUDE_TRANSACTION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeTransactionDetails").getter(KafkaSettings.getter(KafkaSettings::includeTransactionDetails)).setter(KafkaSettings.setter(Builder::includeTransactionDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeTransactionDetails").build()}).build();
    private static final SdkField<Boolean> INCLUDE_PARTITION_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludePartitionValue").getter(KafkaSettings.getter(KafkaSettings::includePartitionValue)).setter(KafkaSettings.setter(Builder::includePartitionValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludePartitionValue").build()}).build();
    private static final SdkField<Boolean> PARTITION_INCLUDE_SCHEMA_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PartitionIncludeSchemaTable").getter(KafkaSettings.getter(KafkaSettings::partitionIncludeSchemaTable)).setter(KafkaSettings.setter(Builder::partitionIncludeSchemaTable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionIncludeSchemaTable").build()}).build();
    private static final SdkField<Boolean> INCLUDE_TABLE_ALTER_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeTableAlterOperations").getter(KafkaSettings.getter(KafkaSettings::includeTableAlterOperations)).setter(KafkaSettings.setter(Builder::includeTableAlterOperations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeTableAlterOperations").build()}).build();
    private static final SdkField<Boolean> INCLUDE_CONTROL_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeControlDetails").getter(KafkaSettings.getter(KafkaSettings::includeControlDetails)).setter(KafkaSettings.setter(Builder::includeControlDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeControlDetails").build()}).build();
    private static final SdkField<Integer> MESSAGE_MAX_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MessageMaxBytes").getter(KafkaSettings.getter(KafkaSettings::messageMaxBytes)).setter(KafkaSettings.setter(Builder::messageMaxBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageMaxBytes").build()}).build();
    private static final SdkField<Boolean> INCLUDE_NULL_AND_EMPTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeNullAndEmpty").getter(KafkaSettings.getter(KafkaSettings::includeNullAndEmpty)).setter(KafkaSettings.setter(Builder::includeNullAndEmpty)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeNullAndEmpty").build()}).build();
    private static final SdkField<String> SECURITY_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityProtocol").getter(KafkaSettings.getter(KafkaSettings::securityProtocolAsString)).setter(KafkaSettings.setter(Builder::securityProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityProtocol").build()}).build();
    private static final SdkField<String> SSL_CLIENT_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SslClientCertificateArn").getter(KafkaSettings.getter(KafkaSettings::sslClientCertificateArn)).setter(KafkaSettings.setter(Builder::sslClientCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslClientCertificateArn").build()}).build();
    private static final SdkField<String> SSL_CLIENT_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SslClientKeyArn").getter(KafkaSettings.getter(KafkaSettings::sslClientKeyArn)).setter(KafkaSettings.setter(Builder::sslClientKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslClientKeyArn").build()}).build();
    private static final SdkField<String> SSL_CLIENT_KEY_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SslClientKeyPassword").getter(KafkaSettings.getter(KafkaSettings::sslClientKeyPassword)).setter(KafkaSettings.setter(Builder::sslClientKeyPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslClientKeyPassword").build()}).build();
    private static final SdkField<String> SSL_CA_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SslCaCertificateArn").getter(KafkaSettings.getter(KafkaSettings::sslCaCertificateArn)).setter(KafkaSettings.setter(Builder::sslCaCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslCaCertificateArn").build()}).build();
    private static final SdkField<String> SASL_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SaslUsername").getter(KafkaSettings.getter(KafkaSettings::saslUsername)).setter(KafkaSettings.setter(Builder::saslUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SaslUsername").build()}).build();
    private static final SdkField<String> SASL_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SaslPassword").getter(KafkaSettings.getter(KafkaSettings::saslPassword)).setter(KafkaSettings.setter(Builder::saslPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SaslPassword").build()}).build();
    private static final SdkField<Boolean> NO_HEX_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NoHexPrefix").getter(KafkaSettings.getter(KafkaSettings::noHexPrefix)).setter(KafkaSettings.setter(Builder::noHexPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoHexPrefix").build()}).build();
    private static final SdkField<String> SASL_MECHANISM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SaslMechanism").getter(KafkaSettings.getter(KafkaSettings::saslMechanismAsString)).setter(KafkaSettings.setter(Builder::saslMechanism)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SaslMechanism").build()}).build();
    private static final SdkField<String> SSL_ENDPOINT_IDENTIFICATION_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SslEndpointIdentificationAlgorithm").getter(KafkaSettings.getter(KafkaSettings::sslEndpointIdentificationAlgorithmAsString)).setter(KafkaSettings.setter(Builder::sslEndpointIdentificationAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslEndpointIdentificationAlgorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_FIELD, TOPIC_FIELD, MESSAGE_FORMAT_FIELD, INCLUDE_TRANSACTION_DETAILS_FIELD, INCLUDE_PARTITION_VALUE_FIELD, PARTITION_INCLUDE_SCHEMA_TABLE_FIELD, INCLUDE_TABLE_ALTER_OPERATIONS_FIELD, INCLUDE_CONTROL_DETAILS_FIELD, MESSAGE_MAX_BYTES_FIELD, INCLUDE_NULL_AND_EMPTY_FIELD, SECURITY_PROTOCOL_FIELD, SSL_CLIENT_CERTIFICATE_ARN_FIELD, SSL_CLIENT_KEY_ARN_FIELD, SSL_CLIENT_KEY_PASSWORD_FIELD, SSL_CA_CERTIFICATE_ARN_FIELD, SASL_USERNAME_FIELD, SASL_PASSWORD_FIELD, NO_HEX_PREFIX_FIELD, SASL_MECHANISM_FIELD, SSL_ENDPOINT_IDENTIFICATION_ALGORITHM_FIELD));
    private static final long serialVersionUID = 1L;
    private final String broker;
    private final String topic;
    private final String messageFormat;
    private final Boolean includeTransactionDetails;
    private final Boolean includePartitionValue;
    private final Boolean partitionIncludeSchemaTable;
    private final Boolean includeTableAlterOperations;
    private final Boolean includeControlDetails;
    private final Integer messageMaxBytes;
    private final Boolean includeNullAndEmpty;
    private final String securityProtocol;
    private final String sslClientCertificateArn;
    private final String sslClientKeyArn;
    private final String sslClientKeyPassword;
    private final String sslCaCertificateArn;
    private final String saslUsername;
    private final String saslPassword;
    private final Boolean noHexPrefix;
    private final String saslMechanism;
    private final String sslEndpointIdentificationAlgorithm;

    private KafkaSettings(BuilderImpl builder) {
        this.broker = builder.broker;
        this.topic = builder.topic;
        this.messageFormat = builder.messageFormat;
        this.includeTransactionDetails = builder.includeTransactionDetails;
        this.includePartitionValue = builder.includePartitionValue;
        this.partitionIncludeSchemaTable = builder.partitionIncludeSchemaTable;
        this.includeTableAlterOperations = builder.includeTableAlterOperations;
        this.includeControlDetails = builder.includeControlDetails;
        this.messageMaxBytes = builder.messageMaxBytes;
        this.includeNullAndEmpty = builder.includeNullAndEmpty;
        this.securityProtocol = builder.securityProtocol;
        this.sslClientCertificateArn = builder.sslClientCertificateArn;
        this.sslClientKeyArn = builder.sslClientKeyArn;
        this.sslClientKeyPassword = builder.sslClientKeyPassword;
        this.sslCaCertificateArn = builder.sslCaCertificateArn;
        this.saslUsername = builder.saslUsername;
        this.saslPassword = builder.saslPassword;
        this.noHexPrefix = builder.noHexPrefix;
        this.saslMechanism = builder.saslMechanism;
        this.sslEndpointIdentificationAlgorithm = builder.sslEndpointIdentificationAlgorithm;
    }

    public final String broker() {
        return this.broker;
    }

    public final String topic() {
        return this.topic;
    }

    public final MessageFormatValue messageFormat() {
        return MessageFormatValue.fromValue(this.messageFormat);
    }

    public final String messageFormatAsString() {
        return this.messageFormat;
    }

    public final Boolean includeTransactionDetails() {
        return this.includeTransactionDetails;
    }

    public final Boolean includePartitionValue() {
        return this.includePartitionValue;
    }

    public final Boolean partitionIncludeSchemaTable() {
        return this.partitionIncludeSchemaTable;
    }

    public final Boolean includeTableAlterOperations() {
        return this.includeTableAlterOperations;
    }

    public final Boolean includeControlDetails() {
        return this.includeControlDetails;
    }

    public final Integer messageMaxBytes() {
        return this.messageMaxBytes;
    }

    public final Boolean includeNullAndEmpty() {
        return this.includeNullAndEmpty;
    }

    public final KafkaSecurityProtocol securityProtocol() {
        return KafkaSecurityProtocol.fromValue(this.securityProtocol);
    }

    public final String securityProtocolAsString() {
        return this.securityProtocol;
    }

    public final String sslClientCertificateArn() {
        return this.sslClientCertificateArn;
    }

    public final String sslClientKeyArn() {
        return this.sslClientKeyArn;
    }

    public final String sslClientKeyPassword() {
        return this.sslClientKeyPassword;
    }

    public final String sslCaCertificateArn() {
        return this.sslCaCertificateArn;
    }

    public final String saslUsername() {
        return this.saslUsername;
    }

    public final String saslPassword() {
        return this.saslPassword;
    }

    public final Boolean noHexPrefix() {
        return this.noHexPrefix;
    }

    public final KafkaSaslMechanism saslMechanism() {
        return KafkaSaslMechanism.fromValue(this.saslMechanism);
    }

    public final String saslMechanismAsString() {
        return this.saslMechanism;
    }

    public final KafkaSslEndpointIdentificationAlgorithm sslEndpointIdentificationAlgorithm() {
        return KafkaSslEndpointIdentificationAlgorithm.fromValue(this.sslEndpointIdentificationAlgorithm);
    }

    public final String sslEndpointIdentificationAlgorithmAsString() {
        return this.sslEndpointIdentificationAlgorithm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.broker());
        hashCode = 31 * hashCode + Objects.hashCode(this.topic());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeTransactionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.includePartitionValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionIncludeSchemaTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeTableAlterOperations());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeControlDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageMaxBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeNullAndEmpty());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslClientCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslClientKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslClientKeyPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslCaCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.saslUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.saslPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.noHexPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.saslMechanismAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslEndpointIdentificationAlgorithmAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KafkaSettings)) {
            return false;
        }
        KafkaSettings other = (KafkaSettings)obj;
        return Objects.equals(this.broker(), other.broker()) && Objects.equals(this.topic(), other.topic()) && Objects.equals(this.messageFormatAsString(), other.messageFormatAsString()) && Objects.equals(this.includeTransactionDetails(), other.includeTransactionDetails()) && Objects.equals(this.includePartitionValue(), other.includePartitionValue()) && Objects.equals(this.partitionIncludeSchemaTable(), other.partitionIncludeSchemaTable()) && Objects.equals(this.includeTableAlterOperations(), other.includeTableAlterOperations()) && Objects.equals(this.includeControlDetails(), other.includeControlDetails()) && Objects.equals(this.messageMaxBytes(), other.messageMaxBytes()) && Objects.equals(this.includeNullAndEmpty(), other.includeNullAndEmpty()) && Objects.equals(this.securityProtocolAsString(), other.securityProtocolAsString()) && Objects.equals(this.sslClientCertificateArn(), other.sslClientCertificateArn()) && Objects.equals(this.sslClientKeyArn(), other.sslClientKeyArn()) && Objects.equals(this.sslClientKeyPassword(), other.sslClientKeyPassword()) && Objects.equals(this.sslCaCertificateArn(), other.sslCaCertificateArn()) && Objects.equals(this.saslUsername(), other.saslUsername()) && Objects.equals(this.saslPassword(), other.saslPassword()) && Objects.equals(this.noHexPrefix(), other.noHexPrefix()) && Objects.equals(this.saslMechanismAsString(), other.saslMechanismAsString()) && Objects.equals(this.sslEndpointIdentificationAlgorithmAsString(), other.sslEndpointIdentificationAlgorithmAsString());
    }

    public final String toString() {
        return ToString.builder((String)"KafkaSettings").add("Broker", (Object)this.broker()).add("Topic", (Object)this.topic()).add("MessageFormat", (Object)this.messageFormatAsString()).add("IncludeTransactionDetails", (Object)this.includeTransactionDetails()).add("IncludePartitionValue", (Object)this.includePartitionValue()).add("PartitionIncludeSchemaTable", (Object)this.partitionIncludeSchemaTable()).add("IncludeTableAlterOperations", (Object)this.includeTableAlterOperations()).add("IncludeControlDetails", (Object)this.includeControlDetails()).add("MessageMaxBytes", (Object)this.messageMaxBytes()).add("IncludeNullAndEmpty", (Object)this.includeNullAndEmpty()).add("SecurityProtocol", (Object)this.securityProtocolAsString()).add("SslClientCertificateArn", (Object)this.sslClientCertificateArn()).add("SslClientKeyArn", (Object)this.sslClientKeyArn()).add("SslClientKeyPassword", (Object)(this.sslClientKeyPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("SslCaCertificateArn", (Object)this.sslCaCertificateArn()).add("SaslUsername", (Object)this.saslUsername()).add("SaslPassword", (Object)(this.saslPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("NoHexPrefix", (Object)this.noHexPrefix()).add("SaslMechanism", (Object)this.saslMechanismAsString()).add("SslEndpointIdentificationAlgorithm", (Object)this.sslEndpointIdentificationAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Broker": {
                return Optional.ofNullable(clazz.cast(this.broker()));
            }
            case "Topic": {
                return Optional.ofNullable(clazz.cast(this.topic()));
            }
            case "MessageFormat": {
                return Optional.ofNullable(clazz.cast(this.messageFormatAsString()));
            }
            case "IncludeTransactionDetails": {
                return Optional.ofNullable(clazz.cast(this.includeTransactionDetails()));
            }
            case "IncludePartitionValue": {
                return Optional.ofNullable(clazz.cast(this.includePartitionValue()));
            }
            case "PartitionIncludeSchemaTable": {
                return Optional.ofNullable(clazz.cast(this.partitionIncludeSchemaTable()));
            }
            case "IncludeTableAlterOperations": {
                return Optional.ofNullable(clazz.cast(this.includeTableAlterOperations()));
            }
            case "IncludeControlDetails": {
                return Optional.ofNullable(clazz.cast(this.includeControlDetails()));
            }
            case "MessageMaxBytes": {
                return Optional.ofNullable(clazz.cast(this.messageMaxBytes()));
            }
            case "IncludeNullAndEmpty": {
                return Optional.ofNullable(clazz.cast(this.includeNullAndEmpty()));
            }
            case "SecurityProtocol": {
                return Optional.ofNullable(clazz.cast(this.securityProtocolAsString()));
            }
            case "SslClientCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.sslClientCertificateArn()));
            }
            case "SslClientKeyArn": {
                return Optional.ofNullable(clazz.cast(this.sslClientKeyArn()));
            }
            case "SslClientKeyPassword": {
                return Optional.ofNullable(clazz.cast(this.sslClientKeyPassword()));
            }
            case "SslCaCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.sslCaCertificateArn()));
            }
            case "SaslUsername": {
                return Optional.ofNullable(clazz.cast(this.saslUsername()));
            }
            case "SaslPassword": {
                return Optional.ofNullable(clazz.cast(this.saslPassword()));
            }
            case "NoHexPrefix": {
                return Optional.ofNullable(clazz.cast(this.noHexPrefix()));
            }
            case "SaslMechanism": {
                return Optional.ofNullable(clazz.cast(this.saslMechanismAsString()));
            }
            case "SslEndpointIdentificationAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.sslEndpointIdentificationAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KafkaSettings, T> g) {
        return obj -> g.apply((KafkaSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String broker;
        private String topic;
        private String messageFormat;
        private Boolean includeTransactionDetails;
        private Boolean includePartitionValue;
        private Boolean partitionIncludeSchemaTable;
        private Boolean includeTableAlterOperations;
        private Boolean includeControlDetails;
        private Integer messageMaxBytes;
        private Boolean includeNullAndEmpty;
        private String securityProtocol;
        private String sslClientCertificateArn;
        private String sslClientKeyArn;
        private String sslClientKeyPassword;
        private String sslCaCertificateArn;
        private String saslUsername;
        private String saslPassword;
        private Boolean noHexPrefix;
        private String saslMechanism;
        private String sslEndpointIdentificationAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(KafkaSettings model) {
            this.broker(model.broker);
            this.topic(model.topic);
            this.messageFormat(model.messageFormat);
            this.includeTransactionDetails(model.includeTransactionDetails);
            this.includePartitionValue(model.includePartitionValue);
            this.partitionIncludeSchemaTable(model.partitionIncludeSchemaTable);
            this.includeTableAlterOperations(model.includeTableAlterOperations);
            this.includeControlDetails(model.includeControlDetails);
            this.messageMaxBytes(model.messageMaxBytes);
            this.includeNullAndEmpty(model.includeNullAndEmpty);
            this.securityProtocol(model.securityProtocol);
            this.sslClientCertificateArn(model.sslClientCertificateArn);
            this.sslClientKeyArn(model.sslClientKeyArn);
            this.sslClientKeyPassword(model.sslClientKeyPassword);
            this.sslCaCertificateArn(model.sslCaCertificateArn);
            this.saslUsername(model.saslUsername);
            this.saslPassword(model.saslPassword);
            this.noHexPrefix(model.noHexPrefix);
            this.saslMechanism(model.saslMechanism);
            this.sslEndpointIdentificationAlgorithm(model.sslEndpointIdentificationAlgorithm);
        }

        public final String getBroker() {
            return this.broker;
        }

        public final void setBroker(String broker) {
            this.broker = broker;
        }

        @Override
        public final Builder broker(String broker) {
            this.broker = broker;
            return this;
        }

        public final String getTopic() {
            return this.topic;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final String getMessageFormat() {
            return this.messageFormat;
        }

        public final void setMessageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
        }

        @Override
        public final Builder messageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        @Override
        public final Builder messageFormat(MessageFormatValue messageFormat) {
            this.messageFormat(messageFormat == null ? null : messageFormat.toString());
            return this;
        }

        public final Boolean getIncludeTransactionDetails() {
            return this.includeTransactionDetails;
        }

        public final void setIncludeTransactionDetails(Boolean includeTransactionDetails) {
            this.includeTransactionDetails = includeTransactionDetails;
        }

        @Override
        public final Builder includeTransactionDetails(Boolean includeTransactionDetails) {
            this.includeTransactionDetails = includeTransactionDetails;
            return this;
        }

        public final Boolean getIncludePartitionValue() {
            return this.includePartitionValue;
        }

        public final void setIncludePartitionValue(Boolean includePartitionValue) {
            this.includePartitionValue = includePartitionValue;
        }

        @Override
        public final Builder includePartitionValue(Boolean includePartitionValue) {
            this.includePartitionValue = includePartitionValue;
            return this;
        }

        public final Boolean getPartitionIncludeSchemaTable() {
            return this.partitionIncludeSchemaTable;
        }

        public final void setPartitionIncludeSchemaTable(Boolean partitionIncludeSchemaTable) {
            this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
        }

        @Override
        public final Builder partitionIncludeSchemaTable(Boolean partitionIncludeSchemaTable) {
            this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
            return this;
        }

        public final Boolean getIncludeTableAlterOperations() {
            return this.includeTableAlterOperations;
        }

        public final void setIncludeTableAlterOperations(Boolean includeTableAlterOperations) {
            this.includeTableAlterOperations = includeTableAlterOperations;
        }

        @Override
        public final Builder includeTableAlterOperations(Boolean includeTableAlterOperations) {
            this.includeTableAlterOperations = includeTableAlterOperations;
            return this;
        }

        public final Boolean getIncludeControlDetails() {
            return this.includeControlDetails;
        }

        public final void setIncludeControlDetails(Boolean includeControlDetails) {
            this.includeControlDetails = includeControlDetails;
        }

        @Override
        public final Builder includeControlDetails(Boolean includeControlDetails) {
            this.includeControlDetails = includeControlDetails;
            return this;
        }

        public final Integer getMessageMaxBytes() {
            return this.messageMaxBytes;
        }

        public final void setMessageMaxBytes(Integer messageMaxBytes) {
            this.messageMaxBytes = messageMaxBytes;
        }

        @Override
        public final Builder messageMaxBytes(Integer messageMaxBytes) {
            this.messageMaxBytes = messageMaxBytes;
            return this;
        }

        public final Boolean getIncludeNullAndEmpty() {
            return this.includeNullAndEmpty;
        }

        public final void setIncludeNullAndEmpty(Boolean includeNullAndEmpty) {
            this.includeNullAndEmpty = includeNullAndEmpty;
        }

        @Override
        public final Builder includeNullAndEmpty(Boolean includeNullAndEmpty) {
            this.includeNullAndEmpty = includeNullAndEmpty;
            return this;
        }

        public final String getSecurityProtocol() {
            return this.securityProtocol;
        }

        public final void setSecurityProtocol(String securityProtocol) {
            this.securityProtocol = securityProtocol;
        }

        @Override
        public final Builder securityProtocol(String securityProtocol) {
            this.securityProtocol = securityProtocol;
            return this;
        }

        @Override
        public final Builder securityProtocol(KafkaSecurityProtocol securityProtocol) {
            this.securityProtocol(securityProtocol == null ? null : securityProtocol.toString());
            return this;
        }

        public final String getSslClientCertificateArn() {
            return this.sslClientCertificateArn;
        }

        public final void setSslClientCertificateArn(String sslClientCertificateArn) {
            this.sslClientCertificateArn = sslClientCertificateArn;
        }

        @Override
        public final Builder sslClientCertificateArn(String sslClientCertificateArn) {
            this.sslClientCertificateArn = sslClientCertificateArn;
            return this;
        }

        public final String getSslClientKeyArn() {
            return this.sslClientKeyArn;
        }

        public final void setSslClientKeyArn(String sslClientKeyArn) {
            this.sslClientKeyArn = sslClientKeyArn;
        }

        @Override
        public final Builder sslClientKeyArn(String sslClientKeyArn) {
            this.sslClientKeyArn = sslClientKeyArn;
            return this;
        }

        public final String getSslClientKeyPassword() {
            return this.sslClientKeyPassword;
        }

        public final void setSslClientKeyPassword(String sslClientKeyPassword) {
            this.sslClientKeyPassword = sslClientKeyPassword;
        }

        @Override
        public final Builder sslClientKeyPassword(String sslClientKeyPassword) {
            this.sslClientKeyPassword = sslClientKeyPassword;
            return this;
        }

        public final String getSslCaCertificateArn() {
            return this.sslCaCertificateArn;
        }

        public final void setSslCaCertificateArn(String sslCaCertificateArn) {
            this.sslCaCertificateArn = sslCaCertificateArn;
        }

        @Override
        public final Builder sslCaCertificateArn(String sslCaCertificateArn) {
            this.sslCaCertificateArn = sslCaCertificateArn;
            return this;
        }

        public final String getSaslUsername() {
            return this.saslUsername;
        }

        public final void setSaslUsername(String saslUsername) {
            this.saslUsername = saslUsername;
        }

        @Override
        public final Builder saslUsername(String saslUsername) {
            this.saslUsername = saslUsername;
            return this;
        }

        public final String getSaslPassword() {
            return this.saslPassword;
        }

        public final void setSaslPassword(String saslPassword) {
            this.saslPassword = saslPassword;
        }

        @Override
        public final Builder saslPassword(String saslPassword) {
            this.saslPassword = saslPassword;
            return this;
        }

        public final Boolean getNoHexPrefix() {
            return this.noHexPrefix;
        }

        public final void setNoHexPrefix(Boolean noHexPrefix) {
            this.noHexPrefix = noHexPrefix;
        }

        @Override
        public final Builder noHexPrefix(Boolean noHexPrefix) {
            this.noHexPrefix = noHexPrefix;
            return this;
        }

        public final String getSaslMechanism() {
            return this.saslMechanism;
        }

        public final void setSaslMechanism(String saslMechanism) {
            this.saslMechanism = saslMechanism;
        }

        @Override
        public final Builder saslMechanism(String saslMechanism) {
            this.saslMechanism = saslMechanism;
            return this;
        }

        @Override
        public final Builder saslMechanism(KafkaSaslMechanism saslMechanism) {
            this.saslMechanism(saslMechanism == null ? null : saslMechanism.toString());
            return this;
        }

        public final String getSslEndpointIdentificationAlgorithm() {
            return this.sslEndpointIdentificationAlgorithm;
        }

        public final void setSslEndpointIdentificationAlgorithm(String sslEndpointIdentificationAlgorithm) {
            this.sslEndpointIdentificationAlgorithm = sslEndpointIdentificationAlgorithm;
        }

        @Override
        public final Builder sslEndpointIdentificationAlgorithm(String sslEndpointIdentificationAlgorithm) {
            this.sslEndpointIdentificationAlgorithm = sslEndpointIdentificationAlgorithm;
            return this;
        }

        @Override
        public final Builder sslEndpointIdentificationAlgorithm(KafkaSslEndpointIdentificationAlgorithm sslEndpointIdentificationAlgorithm) {
            this.sslEndpointIdentificationAlgorithm(sslEndpointIdentificationAlgorithm == null ? null : sslEndpointIdentificationAlgorithm.toString());
            return this;
        }

        public KafkaSettings build() {
            return new KafkaSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KafkaSettings> {
        public Builder broker(String var1);

        public Builder topic(String var1);

        public Builder messageFormat(String var1);

        public Builder messageFormat(MessageFormatValue var1);

        public Builder includeTransactionDetails(Boolean var1);

        public Builder includePartitionValue(Boolean var1);

        public Builder partitionIncludeSchemaTable(Boolean var1);

        public Builder includeTableAlterOperations(Boolean var1);

        public Builder includeControlDetails(Boolean var1);

        public Builder messageMaxBytes(Integer var1);

        public Builder includeNullAndEmpty(Boolean var1);

        public Builder securityProtocol(String var1);

        public Builder securityProtocol(KafkaSecurityProtocol var1);

        public Builder sslClientCertificateArn(String var1);

        public Builder sslClientKeyArn(String var1);

        public Builder sslClientKeyPassword(String var1);

        public Builder sslCaCertificateArn(String var1);

        public Builder saslUsername(String var1);

        public Builder saslPassword(String var1);

        public Builder noHexPrefix(Boolean var1);

        public Builder saslMechanism(String var1);

        public Builder saslMechanism(KafkaSaslMechanism var1);

        public Builder sslEndpointIdentificationAlgorithm(String var1);

        public Builder sslEndpointIdentificationAlgorithm(KafkaSslEndpointIdentificationAlgorithm var1);
    }
}

