/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesResponse;

public class DescribeInstanceProfilesIterable
implements SdkIterable<DescribeInstanceProfilesResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeInstanceProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInstanceProfilesIterable(DatabaseMigrationClient client, DescribeInstanceProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeInstanceProfilesResponseFetcher();
    }

    public Iterator<DescribeInstanceProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeInstanceProfilesResponseFetcher
    implements SyncPageFetcher<DescribeInstanceProfilesResponse> {
        private DescribeInstanceProfilesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeInstanceProfilesResponse nextPage(DescribeInstanceProfilesResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceProfilesIterable.this.client.describeInstanceProfiles(DescribeInstanceProfilesIterable.this.firstRequest);
            }
            return DescribeInstanceProfilesIterable.this.client.describeInstanceProfiles((DescribeInstanceProfilesRequest)((Object)DescribeInstanceProfilesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

