/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsResponse;

public class DescribeReplicationsIterable
implements SdkIterable<DescribeReplicationsResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeReplicationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReplicationsIterable(DatabaseMigrationClient client, DescribeReplicationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeReplicationsResponseFetcher();
    }

    public Iterator<DescribeReplicationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeReplicationsResponseFetcher
    implements SyncPageFetcher<DescribeReplicationsResponse> {
        private DescribeReplicationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeReplicationsResponse nextPage(DescribeReplicationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReplicationsIterable.this.client.describeReplications(DescribeReplicationsIterable.this.firstRequest);
            }
            return DescribeReplicationsIterable.this.client.describeReplications((DescribeReplicationsRequest)((Object)DescribeReplicationsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

