/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SampleMode {
    FULL_DATASET("FULL_DATASET"),
    CUSTOM_ROWS("CUSTOM_ROWS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SampleMode> VALUE_MAP;
    private final String value;

    private SampleMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SampleMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SampleMode> knownValues() {
        EnumSet<SampleMode> knownValues = EnumSet.allOf(SampleMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SampleMode.class, SampleMode::toString);
    }
}

