/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.datapipeline.DataPipelineAsyncClient;
import software.amazon.awssdk.services.datapipeline.internal.UserAgentUtils;
import software.amazon.awssdk.services.datapipeline.model.DescribeObjectsRequest;
import software.amazon.awssdk.services.datapipeline.model.DescribeObjectsResponse;
import software.amazon.awssdk.services.datapipeline.model.PipelineObject;

public class DescribeObjectsPublisher
implements SdkPublisher<DescribeObjectsResponse> {
    private final DataPipelineAsyncClient client;
    private final DescribeObjectsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeObjectsPublisher(DataPipelineAsyncClient client, DescribeObjectsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeObjectsPublisher(DataPipelineAsyncClient client, DescribeObjectsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeObjectsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeObjectsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PipelineObject> pipelineObjects() {
        Function<DescribeObjectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.pipelineObjects() != null) {
                return response.pipelineObjects().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeObjectsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeObjectsResponseFetcher
    implements AsyncPageFetcher<DescribeObjectsResponse> {
        private DescribeObjectsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeObjectsResponse previousPage) {
            return previousPage.hasMoreResults();
        }

        public CompletableFuture<DescribeObjectsResponse> nextPage(DescribeObjectsResponse previousPage) {
            if (previousPage == null) {
                return DescribeObjectsPublisher.this.client.describeObjects(DescribeObjectsPublisher.this.firstRequest);
            }
            return DescribeObjectsPublisher.this.client.describeObjects((DescribeObjectsRequest)((Object)DescribeObjectsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

