/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.DataSyncException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvalidRequestException
extends DataSyncException
implements ToCopyableBuilder<Builder, InvalidRequestException> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorCode").getter(InvalidRequestException.getter(InvalidRequestException::errorCode)).setter(InvalidRequestException.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<String> DATASYNC_ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasyncErrorCode").getter(InvalidRequestException.getter(InvalidRequestException::datasyncErrorCode)).setter(InvalidRequestException.setter(Builder::datasyncErrorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasyncErrorCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD, DATASYNC_ERROR_CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String errorCode;
    private final String datasyncErrorCode;

    private InvalidRequestException(BuilderImpl builder) {
        super(builder);
        this.errorCode = builder.errorCode;
        this.datasyncErrorCode = builder.datasyncErrorCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String datasyncErrorCode() {
        return this.datasyncErrorCode;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvalidRequestException, T> g) {
        return obj -> g.apply((InvalidRequestException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncException.BuilderImpl
    implements Builder {
        private String errorCode;
        private String datasyncErrorCode;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidRequestException model) {
            super(model);
            this.errorCode(model.errorCode);
            this.datasyncErrorCode(model.datasyncErrorCode);
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getDatasyncErrorCode() {
            return this.datasyncErrorCode;
        }

        public final void setDatasyncErrorCode(String datasyncErrorCode) {
            this.datasyncErrorCode = datasyncErrorCode;
        }

        @Override
        public final Builder datasyncErrorCode(String datasyncErrorCode) {
            this.datasyncErrorCode = datasyncErrorCode;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public InvalidRequestException build() {
            return new InvalidRequestException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvalidRequestException>,
    DataSyncException.Builder {
        public Builder errorCode(String var1);

        public Builder datasyncErrorCode(String var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);
    }
}

