/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataSourceRunStatus {
    REQUESTED("REQUESTED"),
    RUNNING("RUNNING"),
    FAILED("FAILED"),
    PARTIALLY_SUCCEEDED("PARTIALLY_SUCCEEDED"),
    SUCCESS("SUCCESS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataSourceRunStatus> VALUE_MAP;
    private final String value;

    private DataSourceRunStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataSourceRunStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataSourceRunStatus> knownValues() {
        EnumSet<DataSourceRunStatus> knownValues = EnumSet.allOf(DataSourceRunStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataSourceRunStatus.class, DataSourceRunStatus::toString);
    }
}

