/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.SubscribedListing;
import software.amazon.awssdk.services.datazone.model.SubscribedPrincipal;
import software.amazon.awssdk.services.datazone.model.SubscriptionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubscriptionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubscriptionSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(SubscriptionSummary.getter(SubscriptionSummary::createdAt)).setter(SubscriptionSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(SubscriptionSummary.getter(SubscriptionSummary::createdBy)).setter(SubscriptionSummary.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(SubscriptionSummary.getter(SubscriptionSummary::domainId)).setter(SubscriptionSummary.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(SubscriptionSummary.getter(SubscriptionSummary::id)).setter(SubscriptionSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Boolean> RETAIN_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("retainPermissions").getter(SubscriptionSummary.getter(SubscriptionSummary::retainPermissions)).setter(SubscriptionSummary.setter(Builder::retainPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retainPermissions").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(SubscriptionSummary.getter(SubscriptionSummary::statusAsString)).setter(SubscriptionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<SubscribedListing> SUBSCRIBED_LISTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("subscribedListing").getter(SubscriptionSummary.getter(SubscriptionSummary::subscribedListing)).setter(SubscriptionSummary.setter(Builder::subscribedListing)).constructor(SubscribedListing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribedListing").build()}).build();
    private static final SdkField<SubscribedPrincipal> SUBSCRIBED_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("subscribedPrincipal").getter(SubscriptionSummary.getter(SubscriptionSummary::subscribedPrincipal)).setter(SubscriptionSummary.setter(Builder::subscribedPrincipal)).constructor(SubscribedPrincipal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribedPrincipal").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriptionRequestId").getter(SubscriptionSummary.getter(SubscriptionSummary::subscriptionRequestId)).setter(SubscriptionSummary.setter(Builder::subscriptionRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionRequestId").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(SubscriptionSummary.getter(SubscriptionSummary::updatedAt)).setter(SubscriptionSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(SubscriptionSummary.getter(SubscriptionSummary::updatedBy)).setter(SubscriptionSummary.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, CREATED_BY_FIELD, DOMAIN_ID_FIELD, ID_FIELD, RETAIN_PERMISSIONS_FIELD, STATUS_FIELD, SUBSCRIBED_LISTING_FIELD, SUBSCRIBED_PRINCIPAL_FIELD, SUBSCRIPTION_REQUEST_ID_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String createdBy;
    private final String domainId;
    private final String id;
    private final Boolean retainPermissions;
    private final String status;
    private final SubscribedListing subscribedListing;
    private final SubscribedPrincipal subscribedPrincipal;
    private final String subscriptionRequestId;
    private final Instant updatedAt;
    private final String updatedBy;

    private SubscriptionSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.domainId = builder.domainId;
        this.id = builder.id;
        this.retainPermissions = builder.retainPermissions;
        this.status = builder.status;
        this.subscribedListing = builder.subscribedListing;
        this.subscribedPrincipal = builder.subscribedPrincipal;
        this.subscriptionRequestId = builder.subscriptionRequestId;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String id() {
        return this.id;
    }

    public final Boolean retainPermissions() {
        return this.retainPermissions;
    }

    public final SubscriptionStatus status() {
        return SubscriptionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final SubscribedListing subscribedListing() {
        return this.subscribedListing;
    }

    public final SubscribedPrincipal subscribedPrincipal() {
        return this.subscribedPrincipal;
    }

    public final String subscriptionRequestId() {
        return this.subscriptionRequestId;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.retainPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscribedListing());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscribedPrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscriptionSummary)) {
            return false;
        }
        SubscriptionSummary other = (SubscriptionSummary)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.retainPermissions(), other.retainPermissions()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.subscribedListing(), other.subscribedListing()) && Objects.equals(this.subscribedPrincipal(), other.subscribedPrincipal()) && Objects.equals(this.subscriptionRequestId(), other.subscriptionRequestId()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy());
    }

    public final String toString() {
        return ToString.builder((String)"SubscriptionSummary").add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("DomainId", (Object)this.domainId()).add("Id", (Object)this.id()).add("RetainPermissions", (Object)this.retainPermissions()).add("Status", (Object)this.statusAsString()).add("SubscribedListing", (Object)this.subscribedListing()).add("SubscribedPrincipal", (Object)this.subscribedPrincipal()).add("SubscriptionRequestId", (Object)this.subscriptionRequestId()).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "retainPermissions": {
                return Optional.ofNullable(clazz.cast(this.retainPermissions()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "subscribedListing": {
                return Optional.ofNullable(clazz.cast(this.subscribedListing()));
            }
            case "subscribedPrincipal": {
                return Optional.ofNullable(clazz.cast(this.subscribedPrincipal()));
            }
            case "subscriptionRequestId": {
                return Optional.ofNullable(clazz.cast(this.subscriptionRequestId()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubscriptionSummary, T> g) {
        return obj -> g.apply((SubscriptionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String createdBy;
        private String domainId;
        private String id;
        private Boolean retainPermissions;
        private String status;
        private SubscribedListing subscribedListing;
        private SubscribedPrincipal subscribedPrincipal;
        private String subscriptionRequestId;
        private Instant updatedAt;
        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscriptionSummary model) {
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.domainId(model.domainId);
            this.id(model.id);
            this.retainPermissions(model.retainPermissions);
            this.status(model.status);
            this.subscribedListing(model.subscribedListing);
            this.subscribedPrincipal(model.subscribedPrincipal);
            this.subscriptionRequestId(model.subscriptionRequestId);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Boolean getRetainPermissions() {
            return this.retainPermissions;
        }

        public final void setRetainPermissions(Boolean retainPermissions) {
            this.retainPermissions = retainPermissions;
        }

        @Override
        public final Builder retainPermissions(Boolean retainPermissions) {
            this.retainPermissions = retainPermissions;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SubscriptionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final SubscribedListing.Builder getSubscribedListing() {
            return this.subscribedListing != null ? this.subscribedListing.toBuilder() : null;
        }

        public final void setSubscribedListing(SubscribedListing.BuilderImpl subscribedListing) {
            this.subscribedListing = subscribedListing != null ? subscribedListing.build() : null;
        }

        @Override
        public final Builder subscribedListing(SubscribedListing subscribedListing) {
            this.subscribedListing = subscribedListing;
            return this;
        }

        public final SubscribedPrincipal.Builder getSubscribedPrincipal() {
            return this.subscribedPrincipal != null ? this.subscribedPrincipal.toBuilder() : null;
        }

        public final void setSubscribedPrincipal(SubscribedPrincipal.BuilderImpl subscribedPrincipal) {
            this.subscribedPrincipal = subscribedPrincipal != null ? subscribedPrincipal.build() : null;
        }

        @Override
        public final Builder subscribedPrincipal(SubscribedPrincipal subscribedPrincipal) {
            this.subscribedPrincipal = subscribedPrincipal;
            return this;
        }

        public final String getSubscriptionRequestId() {
            return this.subscriptionRequestId;
        }

        public final void setSubscriptionRequestId(String subscriptionRequestId) {
            this.subscriptionRequestId = subscriptionRequestId;
        }

        @Override
        public final Builder subscriptionRequestId(String subscriptionRequestId) {
            this.subscriptionRequestId = subscriptionRequestId;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public SubscriptionSummary build() {
            return new SubscriptionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubscriptionSummary> {
        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder domainId(String var1);

        public Builder id(String var1);

        public Builder retainPermissions(Boolean var1);

        public Builder status(String var1);

        public Builder status(SubscriptionStatus var1);

        public Builder subscribedListing(SubscribedListing var1);

        default public Builder subscribedListing(Consumer<SubscribedListing.Builder> subscribedListing) {
            return this.subscribedListing((SubscribedListing)((SubscribedListing.Builder)SubscribedListing.builder().applyMutation(subscribedListing)).build());
        }

        public Builder subscribedPrincipal(SubscribedPrincipal var1);

        default public Builder subscribedPrincipal(Consumer<SubscribedPrincipal.Builder> subscribedPrincipal) {
            return this.subscribedPrincipal((SubscribedPrincipal)((SubscribedPrincipal.Builder)SubscribedPrincipal.builder().applyMutation(subscribedPrincipal)).build());
        }

        public Builder subscriptionRequestId(String var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);
    }
}

