/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.DataSourceRunSummary;
import software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest;
import software.amazon.awssdk.services.datazone.model.ListDataSourceRunsResponse;

public class ListDataSourceRunsPublisher
implements SdkPublisher<ListDataSourceRunsResponse> {
    private final DataZoneAsyncClient client;
    private final ListDataSourceRunsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataSourceRunsPublisher(DataZoneAsyncClient client, ListDataSourceRunsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataSourceRunsPublisher(DataZoneAsyncClient client, ListDataSourceRunsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataSourceRunsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataSourceRunsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataSourceRunSummary> items() {
        Function<ListDataSourceRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataSourceRunsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataSourceRunsResponseFetcher
    implements AsyncPageFetcher<ListDataSourceRunsResponse> {
        private ListDataSourceRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataSourceRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataSourceRunsResponse> nextPage(ListDataSourceRunsResponse previousPage) {
            if (previousPage == null) {
                return ListDataSourceRunsPublisher.this.client.listDataSourceRuns(ListDataSourceRunsPublisher.this.firstRequest);
            }
            return ListDataSourceRunsPublisher.this.client.listDataSourceRuns((ListDataSourceRunsRequest)((Object)ListDataSourceRunsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

