/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.ListNotificationsRequest;
import software.amazon.awssdk.services.datazone.model.ListNotificationsResponse;
import software.amazon.awssdk.services.datazone.model.NotificationOutput;

public class ListNotificationsIterable
implements SdkIterable<ListNotificationsResponse> {
    private final DataZoneClient client;
    private final ListNotificationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNotificationsIterable(DataZoneClient client, ListNotificationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListNotificationsResponseFetcher();
    }

    public Iterator<ListNotificationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<NotificationOutput> notifications() {
        Function<ListNotificationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.notifications() != null) {
                return response.notifications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListNotificationsResponseFetcher
    implements SyncPageFetcher<ListNotificationsResponse> {
        private ListNotificationsResponseFetcher() {
        }

        public boolean hasNextPage(ListNotificationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListNotificationsResponse nextPage(ListNotificationsResponse previousPage) {
            if (previousPage == null) {
                return ListNotificationsIterable.this.client.listNotifications(ListNotificationsIterable.this.firstRequest);
            }
            return ListNotificationsIterable.this.client.listNotifications((ListNotificationsRequest)((Object)ListNotificationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

