/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.detective.DetectiveClient;
import software.amazon.awssdk.services.detective.internal.UserAgentUtils;
import software.amazon.awssdk.services.detective.model.ListDatasourcePackagesRequest;
import software.amazon.awssdk.services.detective.model.ListDatasourcePackagesResponse;

public class ListDatasourcePackagesIterable
implements SdkIterable<ListDatasourcePackagesResponse> {
    private final DetectiveClient client;
    private final ListDatasourcePackagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDatasourcePackagesIterable(DetectiveClient client, ListDatasourcePackagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDatasourcePackagesResponseFetcher();
    }

    public Iterator<ListDatasourcePackagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDatasourcePackagesResponseFetcher
    implements SyncPageFetcher<ListDatasourcePackagesResponse> {
        private ListDatasourcePackagesResponseFetcher() {
        }

        public boolean hasNextPage(ListDatasourcePackagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDatasourcePackagesResponse nextPage(ListDatasourcePackagesResponse previousPage) {
            if (previousPage == null) {
                return ListDatasourcePackagesIterable.this.client.listDatasourcePackages(ListDatasourcePackagesIterable.this.firstRequest);
            }
            return ListDatasourcePackagesIterable.this.client.listDatasourcePackages((ListDatasourcePackagesRequest)((Object)ListDatasourcePackagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

