/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.detective.DetectiveAsyncClient;
import software.amazon.awssdk.services.detective.internal.UserAgentUtils;
import software.amazon.awssdk.services.detective.model.ListOrganizationAdminAccountsRequest;
import software.amazon.awssdk.services.detective.model.ListOrganizationAdminAccountsResponse;

public class ListOrganizationAdminAccountsPublisher
implements SdkPublisher<ListOrganizationAdminAccountsResponse> {
    private final DetectiveAsyncClient client;
    private final ListOrganizationAdminAccountsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOrganizationAdminAccountsPublisher(DetectiveAsyncClient client, ListOrganizationAdminAccountsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOrganizationAdminAccountsPublisher(DetectiveAsyncClient client, ListOrganizationAdminAccountsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOrganizationAdminAccountsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOrganizationAdminAccountsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListOrganizationAdminAccountsResponseFetcher
    implements AsyncPageFetcher<ListOrganizationAdminAccountsResponse> {
        private ListOrganizationAdminAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListOrganizationAdminAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOrganizationAdminAccountsResponse> nextPage(ListOrganizationAdminAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListOrganizationAdminAccountsPublisher.this.client.listOrganizationAdminAccounts(ListOrganizationAdminAccountsPublisher.this.firstRequest);
            }
            return ListOrganizationAdminAccountsPublisher.this.client.listOrganizationAdminAccounts((ListOrganizationAdminAccountsRequest)((Object)ListOrganizationAdminAccountsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

