/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DirectoryConnectSettings;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.services.directory.model.DirectorySize;
import software.amazon.awssdk.services.directory.model.Tag;
import software.amazon.awssdk.services.directory.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectDirectoryRequest
extends DirectoryRequest
implements ToCopyableBuilder<Builder, ConnectDirectoryRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ConnectDirectoryRequest.getter(ConnectDirectoryRequest::name)).setter(ConnectDirectoryRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SHORT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShortName").getter(ConnectDirectoryRequest.getter(ConnectDirectoryRequest::shortName)).setter(ConnectDirectoryRequest.setter(Builder::shortName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShortName").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Password").getter(ConnectDirectoryRequest.getter(ConnectDirectoryRequest::password)).setter(ConnectDirectoryRequest.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ConnectDirectoryRequest.getter(ConnectDirectoryRequest::description)).setter(ConnectDirectoryRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Size").getter(ConnectDirectoryRequest.getter(ConnectDirectoryRequest::sizeAsString)).setter(ConnectDirectoryRequest.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()}).build();
    private static final SdkField<DirectoryConnectSettings> CONNECT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectSettings").getter(ConnectDirectoryRequest.getter(ConnectDirectoryRequest::connectSettings)).setter(ConnectDirectoryRequest.setter(Builder::connectSettings)).constructor(DirectoryConnectSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectSettings").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ConnectDirectoryRequest.getter(ConnectDirectoryRequest::tags)).setter(ConnectDirectoryRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SHORT_NAME_FIELD, PASSWORD_FIELD, DESCRIPTION_FIELD, SIZE_FIELD, CONNECT_SETTINGS_FIELD, TAGS_FIELD));
    private final String name;
    private final String shortName;
    private final String password;
    private final String description;
    private final String size;
    private final DirectoryConnectSettings connectSettings;
    private final List<Tag> tags;

    private ConnectDirectoryRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.shortName = builder.shortName;
        this.password = builder.password;
        this.description = builder.description;
        this.size = builder.size;
        this.connectSettings = builder.connectSettings;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String shortName() {
        return this.shortName;
    }

    public final String password() {
        return this.password;
    }

    public final String description() {
        return this.description;
    }

    public final DirectorySize size() {
        return DirectorySize.fromValue(this.size);
    }

    public final String sizeAsString() {
        return this.size;
    }

    public final DirectoryConnectSettings connectSettings() {
        return this.connectSettings;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.shortName());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectDirectoryRequest)) {
            return false;
        }
        ConnectDirectoryRequest other = (ConnectDirectoryRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.shortName(), other.shortName()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.sizeAsString(), other.sizeAsString()) && Objects.equals(this.connectSettings(), other.connectSettings()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectDirectoryRequest").add("Name", (Object)this.name()).add("ShortName", (Object)this.shortName()).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)this.description()).add("Size", (Object)this.sizeAsString()).add("ConnectSettings", (Object)this.connectSettings()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ShortName": {
                return Optional.ofNullable(clazz.cast(this.shortName()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.sizeAsString()));
            }
            case "ConnectSettings": {
                return Optional.ofNullable(clazz.cast(this.connectSettings()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectDirectoryRequest, T> g) {
        return obj -> g.apply((ConnectDirectoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryRequest.BuilderImpl
    implements Builder {
        private String name;
        private String shortName;
        private String password;
        private String description;
        private String size;
        private DirectoryConnectSettings connectSettings;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectDirectoryRequest model) {
            super(model);
            this.name(model.name);
            this.shortName(model.shortName);
            this.password(model.password);
            this.description(model.description);
            this.size(model.size);
            this.connectSettings(model.connectSettings);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getShortName() {
            return this.shortName;
        }

        public final void setShortName(String shortName) {
            this.shortName = shortName;
        }

        @Override
        public final Builder shortName(String shortName) {
            this.shortName = shortName;
            return this;
        }

        public final String getPassword() {
            return this.password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSize() {
            return this.size;
        }

        public final void setSize(String size) {
            this.size = size;
        }

        @Override
        public final Builder size(String size) {
            this.size = size;
            return this;
        }

        @Override
        public final Builder size(DirectorySize size) {
            this.size(size == null ? null : size.toString());
            return this;
        }

        public final DirectoryConnectSettings.Builder getConnectSettings() {
            return this.connectSettings != null ? this.connectSettings.toBuilder() : null;
        }

        public final void setConnectSettings(DirectoryConnectSettings.BuilderImpl connectSettings) {
            this.connectSettings = connectSettings != null ? connectSettings.build() : null;
        }

        @Override
        public final Builder connectSettings(DirectoryConnectSettings connectSettings) {
            this.connectSettings = connectSettings;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConnectDirectoryRequest build() {
            return new ConnectDirectoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ConnectDirectoryRequest> {
        public Builder name(String var1);

        public Builder shortName(String var1);

        public Builder password(String var1);

        public Builder description(String var1);

        public Builder size(String var1);

        public Builder size(DirectorySize var1);

        public Builder connectSettings(DirectoryConnectSettings var1);

        default public Builder connectSettings(Consumer<DirectoryConnectSettings.Builder> connectSettings) {
            return this.connectSettings((DirectoryConnectSettings)((DirectoryConnectSettings.Builder)DirectoryConnectSettings.builder().applyMutation(connectSettings)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

