/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DirectoryIdsCopier;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSharedDirectoriesRequest
extends DirectoryRequest
implements ToCopyableBuilder<Builder, DescribeSharedDirectoriesRequest> {
    private static final SdkField<String> OWNER_DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerDirectoryId").getter(DescribeSharedDirectoriesRequest.getter(DescribeSharedDirectoriesRequest::ownerDirectoryId)).setter(DescribeSharedDirectoriesRequest.setter(Builder::ownerDirectoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerDirectoryId").build()}).build();
    private static final SdkField<List<String>> SHARED_DIRECTORY_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SharedDirectoryIds").getter(DescribeSharedDirectoriesRequest.getter(DescribeSharedDirectoriesRequest::sharedDirectoryIds)).setter(DescribeSharedDirectoriesRequest.setter(Builder::sharedDirectoryIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedDirectoryIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeSharedDirectoriesRequest.getter(DescribeSharedDirectoriesRequest::nextToken)).setter(DescribeSharedDirectoriesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(DescribeSharedDirectoriesRequest.getter(DescribeSharedDirectoriesRequest::limit)).setter(DescribeSharedDirectoriesRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_DIRECTORY_ID_FIELD, SHARED_DIRECTORY_IDS_FIELD, NEXT_TOKEN_FIELD, LIMIT_FIELD));
    private final String ownerDirectoryId;
    private final List<String> sharedDirectoryIds;
    private final String nextToken;
    private final Integer limit;

    private DescribeSharedDirectoriesRequest(BuilderImpl builder) {
        super(builder);
        this.ownerDirectoryId = builder.ownerDirectoryId;
        this.sharedDirectoryIds = builder.sharedDirectoryIds;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    public final String ownerDirectoryId() {
        return this.ownerDirectoryId;
    }

    public final boolean hasSharedDirectoryIds() {
        return this.sharedDirectoryIds != null && !(this.sharedDirectoryIds instanceof SdkAutoConstructList);
    }

    public final List<String> sharedDirectoryIds() {
        return this.sharedDirectoryIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer limit() {
        return this.limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerDirectoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSharedDirectoryIds() ? this.sharedDirectoryIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSharedDirectoriesRequest)) {
            return false;
        }
        DescribeSharedDirectoriesRequest other = (DescribeSharedDirectoriesRequest)((Object)obj);
        return Objects.equals(this.ownerDirectoryId(), other.ownerDirectoryId()) && this.hasSharedDirectoryIds() == other.hasSharedDirectoryIds() && Objects.equals(this.sharedDirectoryIds(), other.sharedDirectoryIds()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.limit(), other.limit());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSharedDirectoriesRequest").add("OwnerDirectoryId", (Object)this.ownerDirectoryId()).add("SharedDirectoryIds", this.hasSharedDirectoryIds() ? this.sharedDirectoryIds() : null).add("NextToken", (Object)this.nextToken()).add("Limit", (Object)this.limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerDirectoryId": {
                return Optional.ofNullable(clazz.cast(this.ownerDirectoryId()));
            }
            case "SharedDirectoryIds": {
                return Optional.ofNullable(clazz.cast(this.sharedDirectoryIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSharedDirectoriesRequest, T> g) {
        return obj -> g.apply((DescribeSharedDirectoriesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryRequest.BuilderImpl
    implements Builder {
        private String ownerDirectoryId;
        private List<String> sharedDirectoryIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSharedDirectoriesRequest model) {
            super(model);
            this.ownerDirectoryId(model.ownerDirectoryId);
            this.sharedDirectoryIds(model.sharedDirectoryIds);
            this.nextToken(model.nextToken);
            this.limit(model.limit);
        }

        public final String getOwnerDirectoryId() {
            return this.ownerDirectoryId;
        }

        public final void setOwnerDirectoryId(String ownerDirectoryId) {
            this.ownerDirectoryId = ownerDirectoryId;
        }

        @Override
        public final Builder ownerDirectoryId(String ownerDirectoryId) {
            this.ownerDirectoryId = ownerDirectoryId;
            return this;
        }

        public final Collection<String> getSharedDirectoryIds() {
            if (this.sharedDirectoryIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sharedDirectoryIds;
        }

        public final void setSharedDirectoryIds(Collection<String> sharedDirectoryIds) {
            this.sharedDirectoryIds = DirectoryIdsCopier.copy(sharedDirectoryIds);
        }

        @Override
        public final Builder sharedDirectoryIds(Collection<String> sharedDirectoryIds) {
            this.sharedDirectoryIds = DirectoryIdsCopier.copy(sharedDirectoryIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedDirectoryIds(String ... sharedDirectoryIds) {
            this.sharedDirectoryIds(Arrays.asList(sharedDirectoryIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSharedDirectoriesRequest build() {
            return new DescribeSharedDirectoriesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSharedDirectoriesRequest> {
        public Builder ownerDirectoryId(String var1);

        public Builder sharedDirectoryIds(Collection<String> var1);

        public Builder sharedDirectoryIds(String ... var1);

        public Builder nextToken(String var1);

        public Builder limit(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

