/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dlm.model.GettablePolicyStateValues;
import software.amazon.awssdk.services.dlm.model.PolicyTypeValues;
import software.amazon.awssdk.services.dlm.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LifecyclePolicySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LifecyclePolicySummary> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyId").getter(LifecyclePolicySummary.getter(LifecyclePolicySummary::policyId)).setter(LifecyclePolicySummary.setter(Builder::policyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(LifecyclePolicySummary.getter(LifecyclePolicySummary::description)).setter(LifecyclePolicySummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(LifecyclePolicySummary.getter(LifecyclePolicySummary::stateAsString)).setter(LifecyclePolicySummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(LifecyclePolicySummary.getter(LifecyclePolicySummary::tags)).setter(LifecyclePolicySummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyType").getter(LifecyclePolicySummary.getter(LifecyclePolicySummary::policyTypeAsString)).setter(LifecyclePolicySummary.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD, DESCRIPTION_FIELD, STATE_FIELD, TAGS_FIELD, POLICY_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String policyId;
    private final String description;
    private final String state;
    private final Map<String, String> tags;
    private final String policyType;

    private LifecyclePolicySummary(BuilderImpl builder) {
        this.policyId = builder.policyId;
        this.description = builder.description;
        this.state = builder.state;
        this.tags = builder.tags;
        this.policyType = builder.policyType;
    }

    public final String policyId() {
        return this.policyId;
    }

    public final String description() {
        return this.description;
    }

    public final GettablePolicyStateValues state() {
        return GettablePolicyStateValues.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final PolicyTypeValues policyType() {
        return PolicyTypeValues.fromValue(this.policyType);
    }

    public final String policyTypeAsString() {
        return this.policyType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicySummary)) {
            return false;
        }
        LifecyclePolicySummary other = (LifecyclePolicySummary)obj;
        return Objects.equals(this.policyId(), other.policyId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.policyTypeAsString(), other.policyTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LifecyclePolicySummary").add("PolicyId", (Object)this.policyId()).add("Description", (Object)this.description()).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("PolicyType", (Object)this.policyTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyId": {
                return Optional.ofNullable(clazz.cast(this.policyId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "PolicyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicySummary, T> g) {
        return obj -> g.apply((LifecyclePolicySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyId;
        private String description;
        private String state;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String policyType;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicySummary model) {
            this.policyId(model.policyId);
            this.description(model.description);
            this.state(model.state);
            this.tags(model.tags);
            this.policyType(model.policyType);
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(GettablePolicyStateValues state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyTypeValues policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public LifecyclePolicySummary build() {
            return new LifecyclePolicySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LifecyclePolicySummary> {
        public Builder policyId(String var1);

        public Builder description(String var1);

        public Builder state(String var1);

        public Builder state(GettablePolicyStateValues var1);

        public Builder tags(Map<String, String> var1);

        public Builder policyType(String var1);

        public Builder policyType(PolicyTypeValues var1);
    }
}

