/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.drs.DrsAsyncClient;
import software.amazon.awssdk.services.drs.internal.UserAgentUtils;
import software.amazon.awssdk.services.drs.model.DescribeSourceNetworksRequest;
import software.amazon.awssdk.services.drs.model.DescribeSourceNetworksResponse;
import software.amazon.awssdk.services.drs.model.SourceNetwork;

public class DescribeSourceNetworksPublisher
implements SdkPublisher<DescribeSourceNetworksResponse> {
    private final DrsAsyncClient client;
    private final DescribeSourceNetworksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSourceNetworksPublisher(DrsAsyncClient client, DescribeSourceNetworksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSourceNetworksPublisher(DrsAsyncClient client, DescribeSourceNetworksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSourceNetworksResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSourceNetworksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SourceNetwork> items() {
        Function<DescribeSourceNetworksResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeSourceNetworksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeSourceNetworksResponseFetcher
    implements AsyncPageFetcher<DescribeSourceNetworksResponse> {
        private DescribeSourceNetworksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSourceNetworksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSourceNetworksResponse> nextPage(DescribeSourceNetworksResponse previousPage) {
            if (previousPage == null) {
                return DescribeSourceNetworksPublisher.this.client.describeSourceNetworks(DescribeSourceNetworksPublisher.this.firstRequest);
            }
            return DescribeSourceNetworksPublisher.this.client.describeSourceNetworks((DescribeSourceNetworksRequest)((Object)DescribeSourceNetworksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

