/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.drs.DrsClient;
import software.amazon.awssdk.services.drs.internal.UserAgentUtils;
import software.amazon.awssdk.services.drs.model.LaunchAction;
import software.amazon.awssdk.services.drs.model.ListLaunchActionsRequest;
import software.amazon.awssdk.services.drs.model.ListLaunchActionsResponse;

public class ListLaunchActionsIterable
implements SdkIterable<ListLaunchActionsResponse> {
    private final DrsClient client;
    private final ListLaunchActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLaunchActionsIterable(DrsClient client, ListLaunchActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLaunchActionsResponseFetcher();
    }

    public Iterator<ListLaunchActionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LaunchAction> items() {
        Function<ListLaunchActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLaunchActionsResponseFetcher
    implements SyncPageFetcher<ListLaunchActionsResponse> {
        private ListLaunchActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListLaunchActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLaunchActionsResponse nextPage(ListLaunchActionsResponse previousPage) {
            if (previousPage == null) {
                return ListLaunchActionsIterable.this.client.listLaunchActions(ListLaunchActionsIterable.this.firstRequest);
            }
            return ListLaunchActionsIterable.this.client.listLaunchActions((ListLaunchActionsRequest)((Object)ListLaunchActionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

