/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticache.model.CacheEngineVersion;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsResponse;

public class DescribeCacheEngineVersionsIterable
implements SdkIterable<DescribeCacheEngineVersionsResponse> {
    private final ElastiCacheClient client;
    private final DescribeCacheEngineVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCacheEngineVersionsIterable(ElastiCacheClient client, DescribeCacheEngineVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeCacheEngineVersionsResponseFetcher();
    }

    public Iterator<DescribeCacheEngineVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CacheEngineVersion> cacheEngineVersions() {
        Function<DescribeCacheEngineVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.cacheEngineVersions() != null) {
                return response.cacheEngineVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeCacheEngineVersionsResponseFetcher
    implements SyncPageFetcher<DescribeCacheEngineVersionsResponse> {
        private DescribeCacheEngineVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCacheEngineVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeCacheEngineVersionsResponse nextPage(DescribeCacheEngineVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCacheEngineVersionsIterable.this.client.describeCacheEngineVersions(DescribeCacheEngineVersionsIterable.this.firstRequest);
            }
            return DescribeCacheEngineVersionsIterable.this.client.describeCacheEngineVersions((DescribeCacheEngineVersionsRequest)((Object)DescribeCacheEngineVersionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

