/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoadBalancerAddress
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoadBalancerAddress> {
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddress").getter(LoadBalancerAddress.getter(LoadBalancerAddress::ipAddress)).setter(LoadBalancerAddress.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()}).build();
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllocationId").getter(LoadBalancerAddress.getter(LoadBalancerAddress::allocationId)).setter(LoadBalancerAddress.setter(Builder::allocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").build()}).build();
    private static final SdkField<String> PRIVATE_IP_V4_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateIPv4Address").getter(LoadBalancerAddress.getter(LoadBalancerAddress::privateIPv4Address)).setter(LoadBalancerAddress.setter(Builder::privateIPv4Address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIPv4Address").build()}).build();
    private static final SdkField<String> IP_V6_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IPv6Address").getter(LoadBalancerAddress.getter(LoadBalancerAddress::iPv6Address)).setter(LoadBalancerAddress.setter(Builder::iPv6Address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPv6Address").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESS_FIELD, ALLOCATION_ID_FIELD, PRIVATE_IP_V4_ADDRESS_FIELD, IP_V6_ADDRESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ipAddress;
    private final String allocationId;
    private final String privateIPv4Address;
    private final String iPv6Address;

    private LoadBalancerAddress(BuilderImpl builder) {
        this.ipAddress = builder.ipAddress;
        this.allocationId = builder.allocationId;
        this.privateIPv4Address = builder.privateIPv4Address;
        this.iPv6Address = builder.iPv6Address;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final String allocationId() {
        return this.allocationId;
    }

    public final String privateIPv4Address() {
        return this.privateIPv4Address;
    }

    public final String iPv6Address() {
        return this.iPv6Address;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIPv4Address());
        hashCode = 31 * hashCode + Objects.hashCode(this.iPv6Address());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerAddress)) {
            return false;
        }
        LoadBalancerAddress other = (LoadBalancerAddress)obj;
        return Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.allocationId(), other.allocationId()) && Objects.equals(this.privateIPv4Address(), other.privateIPv4Address()) && Objects.equals(this.iPv6Address(), other.iPv6Address());
    }

    public final String toString() {
        return ToString.builder((String)"LoadBalancerAddress").add("IpAddress", (Object)this.ipAddress()).add("AllocationId", (Object)this.allocationId()).add("PrivateIPv4Address", (Object)this.privateIPv4Address()).add("IPv6Address", (Object)this.iPv6Address()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "AllocationId": {
                return Optional.ofNullable(clazz.cast(this.allocationId()));
            }
            case "PrivateIPv4Address": {
                return Optional.ofNullable(clazz.cast(this.privateIPv4Address()));
            }
            case "IPv6Address": {
                return Optional.ofNullable(clazz.cast(this.iPv6Address()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancerAddress, T> g) {
        return obj -> g.apply((LoadBalancerAddress)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipAddress;
        private String allocationId;
        private String privateIPv4Address;
        private String iPv6Address;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerAddress model) {
            this.ipAddress(model.ipAddress);
            this.allocationId(model.allocationId);
            this.privateIPv4Address(model.privateIPv4Address);
            this.iPv6Address(model.iPv6Address);
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final String getPrivateIPv4Address() {
            return this.privateIPv4Address;
        }

        public final void setPrivateIPv4Address(String privateIPv4Address) {
            this.privateIPv4Address = privateIPv4Address;
        }

        @Override
        public final Builder privateIPv4Address(String privateIPv4Address) {
            this.privateIPv4Address = privateIPv4Address;
            return this;
        }

        public final String getIPv6Address() {
            return this.iPv6Address;
        }

        public final void setIPv6Address(String iPv6Address) {
            this.iPv6Address = iPv6Address;
        }

        @Override
        public final Builder iPv6Address(String iPv6Address) {
            this.iPv6Address = iPv6Address;
            return this;
        }

        public LoadBalancerAddress build() {
            return new LoadBalancerAddress(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoadBalancerAddress> {
        public Builder ipAddress(String var1);

        public Builder allocationId(String var1);

        public Builder privateIPv4Address(String var1);

        public Builder iPv6Address(String var1);
    }
}

