/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ActionOnFailure {
    TERMINATE_JOB_FLOW("TERMINATE_JOB_FLOW"),
    TERMINATE_CLUSTER("TERMINATE_CLUSTER"),
    CANCEL_AND_WAIT("CANCEL_AND_WAIT"),
    CONTINUE("CONTINUE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ActionOnFailure> VALUE_MAP;
    private final String value;

    private ActionOnFailure(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActionOnFailure fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActionOnFailure> knownValues() {
        EnumSet<ActionOnFailure> knownValues = EnumSet.allOf(ActionOnFailure.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ActionOnFailure.class, ActionOnFailure::toString);
    }
}

