/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.emrserverless.DefaultEmrServerlessBaseClientBuilder;
import software.amazon.awssdk.services.emrserverless.DefaultEmrServerlessClient;
import software.amazon.awssdk.services.emrserverless.EmrServerlessClient;
import software.amazon.awssdk.services.emrserverless.EmrServerlessClientBuilder;
import software.amazon.awssdk.services.emrserverless.EmrServerlessServiceClientConfiguration;
import software.amazon.awssdk.services.emrserverless.endpoints.EmrServerlessEndpointProvider;

@SdkInternalApi
final class DefaultEmrServerlessClientBuilder
extends DefaultEmrServerlessBaseClientBuilder<EmrServerlessClientBuilder, EmrServerlessClient>
implements EmrServerlessClientBuilder {
    DefaultEmrServerlessClientBuilder() {
    }

    @Override
    public DefaultEmrServerlessClientBuilder endpointProvider(EmrServerlessEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EmrServerlessClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultEmrServerlessClientBuilder.validateClientOptions(clientConfiguration);
        EmrServerlessServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultEmrServerlessClient client = new DefaultEmrServerlessClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private EmrServerlessServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return EmrServerlessServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

