/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.entityresolution.DefaultEntityResolutionAsyncClient;
import software.amazon.awssdk.services.entityresolution.DefaultEntityResolutionBaseClientBuilder;
import software.amazon.awssdk.services.entityresolution.EntityResolutionAsyncClient;
import software.amazon.awssdk.services.entityresolution.EntityResolutionAsyncClientBuilder;
import software.amazon.awssdk.services.entityresolution.EntityResolutionServiceClientConfiguration;
import software.amazon.awssdk.services.entityresolution.endpoints.EntityResolutionEndpointProvider;

@SdkInternalApi
final class DefaultEntityResolutionAsyncClientBuilder
extends DefaultEntityResolutionBaseClientBuilder<EntityResolutionAsyncClientBuilder, EntityResolutionAsyncClient>
implements EntityResolutionAsyncClientBuilder {
    DefaultEntityResolutionAsyncClientBuilder() {
    }

    @Override
    public DefaultEntityResolutionAsyncClientBuilder endpointProvider(EntityResolutionEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EntityResolutionAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultEntityResolutionAsyncClientBuilder.validateClientOptions(clientConfiguration);
        EntityResolutionServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultEntityResolutionAsyncClient client = new DefaultEntityResolutionAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private EntityResolutionServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return EntityResolutionServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

