/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.evidently.EvidentlyAsyncClient;
import software.amazon.awssdk.services.evidently.internal.UserAgentUtils;
import software.amazon.awssdk.services.evidently.model.ListSegmentsRequest;
import software.amazon.awssdk.services.evidently.model.ListSegmentsResponse;
import software.amazon.awssdk.services.evidently.model.Segment;

public class ListSegmentsPublisher
implements SdkPublisher<ListSegmentsResponse> {
    private final EvidentlyAsyncClient client;
    private final ListSegmentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSegmentsPublisher(EvidentlyAsyncClient client, ListSegmentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSegmentsPublisher(EvidentlyAsyncClient client, ListSegmentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSegmentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSegmentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Segment> segments() {
        Function<ListSegmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.segments() != null) {
                return response.segments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSegmentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSegmentsResponseFetcher
    implements AsyncPageFetcher<ListSegmentsResponse> {
        private ListSegmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListSegmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSegmentsResponse> nextPage(ListSegmentsResponse previousPage) {
            if (previousPage == null) {
                return ListSegmentsPublisher.this.client.listSegments(ListSegmentsPublisher.this.firstRequest);
            }
            return ListSegmentsPublisher.this.client.listSegments((ListSegmentsRequest)((Object)ListSegmentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

