/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspace.model.FinspaceRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetKxConnectionStringRequest
extends FinspaceRequest
implements ToCopyableBuilder<Builder, GetKxConnectionStringRequest> {
    private static final SdkField<String> USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userArn").getter(GetKxConnectionStringRequest.getter(GetKxConnectionStringRequest::userArn)).setter(GetKxConnectionStringRequest.setter(Builder::userArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("userArn").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(GetKxConnectionStringRequest.getter(GetKxConnectionStringRequest::environmentId)).setter(GetKxConnectionStringRequest.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentId").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(GetKxConnectionStringRequest.getter(GetKxConnectionStringRequest::clusterName)).setter(GetKxConnectionStringRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clusterName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ARN_FIELD, ENVIRONMENT_ID_FIELD, CLUSTER_NAME_FIELD));
    private final String userArn;
    private final String environmentId;
    private final String clusterName;

    private GetKxConnectionStringRequest(BuilderImpl builder) {
        super(builder);
        this.userArn = builder.userArn;
        this.environmentId = builder.environmentId;
        this.clusterName = builder.clusterName;
    }

    public final String userArn() {
        return this.userArn;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKxConnectionStringRequest)) {
            return false;
        }
        GetKxConnectionStringRequest other = (GetKxConnectionStringRequest)((Object)obj);
        return Objects.equals(this.userArn(), other.userArn()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.clusterName(), other.clusterName());
    }

    public final String toString() {
        return ToString.builder((String)"GetKxConnectionStringRequest").add("UserArn", (Object)this.userArn()).add("EnvironmentId", (Object)this.environmentId()).add("ClusterName", (Object)this.clusterName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userArn": {
                return Optional.ofNullable(clazz.cast(this.userArn()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetKxConnectionStringRequest, T> g) {
        return obj -> g.apply((GetKxConnectionStringRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceRequest.BuilderImpl
    implements Builder {
        private String userArn;
        private String environmentId;
        private String clusterName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKxConnectionStringRequest model) {
            super(model);
            this.userArn(model.userArn);
            this.environmentId(model.environmentId);
            this.clusterName(model.clusterName);
        }

        public final String getUserArn() {
            return this.userArn;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetKxConnectionStringRequest build() {
            return new GetKxConnectionStringRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FinspaceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetKxConnectionStringRequest> {
        public Builder userArn(String var1);

        public Builder environmentId(String var1);

        public Builder clusterName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

