/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.finspace.FinspaceClient;
import software.amazon.awssdk.services.finspace.internal.UserAgentUtils;
import software.amazon.awssdk.services.finspace.model.KxEnvironment;
import software.amazon.awssdk.services.finspace.model.ListKxEnvironmentsRequest;
import software.amazon.awssdk.services.finspace.model.ListKxEnvironmentsResponse;

public class ListKxEnvironmentsIterable
implements SdkIterable<ListKxEnvironmentsResponse> {
    private final FinspaceClient client;
    private final ListKxEnvironmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListKxEnvironmentsIterable(FinspaceClient client, ListKxEnvironmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListKxEnvironmentsResponseFetcher();
    }

    public Iterator<ListKxEnvironmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<KxEnvironment> environments() {
        Function<ListKxEnvironmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.environments() != null) {
                return response.environments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListKxEnvironmentsResponseFetcher
    implements SyncPageFetcher<ListKxEnvironmentsResponse> {
        private ListKxEnvironmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListKxEnvironmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListKxEnvironmentsResponse nextPage(ListKxEnvironmentsResponse previousPage) {
            if (previousPage == null) {
                return ListKxEnvironmentsIterable.this.client.listKxEnvironments(ListKxEnvironmentsIterable.this.firstRequest);
            }
            return ListKxEnvironmentsIterable.this.client.listKxEnvironments((ListKxEnvironmentsRequest)((Object)ListKxEnvironmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

