/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspacedata.model.ErrorCategory;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataViewErrorInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataViewErrorInfo> {
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(DataViewErrorInfo.getter(DataViewErrorInfo::errorMessage)).setter(DataViewErrorInfo.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<String> ERROR_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorCategory").getter(DataViewErrorInfo.getter(DataViewErrorInfo::errorCategoryAsString)).setter(DataViewErrorInfo.setter(Builder::errorCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCategory").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_MESSAGE_FIELD, ERROR_CATEGORY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String errorMessage;
    private final String errorCategory;

    private DataViewErrorInfo(BuilderImpl builder) {
        this.errorMessage = builder.errorMessage;
        this.errorCategory = builder.errorCategory;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final ErrorCategory errorCategory() {
        return ErrorCategory.fromValue(this.errorCategory);
    }

    public final String errorCategoryAsString() {
        return this.errorCategory;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCategoryAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataViewErrorInfo)) {
            return false;
        }
        DataViewErrorInfo other = (DataViewErrorInfo)obj;
        return Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.errorCategoryAsString(), other.errorCategoryAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DataViewErrorInfo").add("ErrorMessage", (Object)this.errorMessage()).add("ErrorCategory", (Object)this.errorCategoryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "errorCategory": {
                return Optional.ofNullable(clazz.cast(this.errorCategoryAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataViewErrorInfo, T> g) {
        return obj -> g.apply((DataViewErrorInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String errorMessage;
        private String errorCategory;

        private BuilderImpl() {
        }

        private BuilderImpl(DataViewErrorInfo model) {
            this.errorMessage(model.errorMessage);
            this.errorCategory(model.errorCategory);
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getErrorCategory() {
            return this.errorCategory;
        }

        public final void setErrorCategory(String errorCategory) {
            this.errorCategory = errorCategory;
        }

        @Override
        public final Builder errorCategory(String errorCategory) {
            this.errorCategory = errorCategory;
            return this;
        }

        @Override
        public final Builder errorCategory(ErrorCategory errorCategory) {
            this.errorCategory(errorCategory == null ? null : errorCategory.toString());
            return this;
        }

        public DataViewErrorInfo build() {
            return new DataViewErrorInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataViewErrorInfo> {
        public Builder errorMessage(String var1);

        public Builder errorCategory(String var1);

        public Builder errorCategory(ErrorCategory var1);
    }
}

