/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fms.FmsAsyncClient;
import software.amazon.awssdk.services.fms.internal.UserAgentUtils;
import software.amazon.awssdk.services.fms.model.ListAdminsManagingAccountRequest;
import software.amazon.awssdk.services.fms.model.ListAdminsManagingAccountResponse;

public class ListAdminsManagingAccountPublisher
implements SdkPublisher<ListAdminsManagingAccountResponse> {
    private final FmsAsyncClient client;
    private final ListAdminsManagingAccountRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAdminsManagingAccountPublisher(FmsAsyncClient client, ListAdminsManagingAccountRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAdminsManagingAccountPublisher(FmsAsyncClient client, ListAdminsManagingAccountRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAdminsManagingAccountResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAdminsManagingAccountResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> adminAccounts() {
        Function<ListAdminsManagingAccountResponse, Iterator> getIterator = response -> {
            if (response != null && response.adminAccounts() != null) {
                return response.adminAccounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAdminsManagingAccountResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAdminsManagingAccountResponseFetcher
    implements AsyncPageFetcher<ListAdminsManagingAccountResponse> {
        private ListAdminsManagingAccountResponseFetcher() {
        }

        public boolean hasNextPage(ListAdminsManagingAccountResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAdminsManagingAccountResponse> nextPage(ListAdminsManagingAccountResponse previousPage) {
            if (previousPage == null) {
                return ListAdminsManagingAccountPublisher.this.client.listAdminsManagingAccount(ListAdminsManagingAccountPublisher.this.firstRequest);
            }
            return ListAdminsManagingAccountPublisher.this.client.listAdminsManagingAccount((ListAdminsManagingAccountRequest)((Object)ListAdminsManagingAccountPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

