/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.frauddetector.model.UncertaintyRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TFIModelPerformance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TFIModelPerformance> {
    private static final SdkField<Float> AUC_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("auc").getter(TFIModelPerformance.getter(TFIModelPerformance::auc)).setter(TFIModelPerformance.setter(Builder::auc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auc").build()}).build();
    private static final SdkField<UncertaintyRange> UNCERTAINTY_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("uncertaintyRange").getter(TFIModelPerformance.getter(TFIModelPerformance::uncertaintyRange)).setter(TFIModelPerformance.setter(Builder::uncertaintyRange)).constructor(UncertaintyRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uncertaintyRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUC_FIELD, UNCERTAINTY_RANGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Float auc;
    private final UncertaintyRange uncertaintyRange;

    private TFIModelPerformance(BuilderImpl builder) {
        this.auc = builder.auc;
        this.uncertaintyRange = builder.uncertaintyRange;
    }

    public final Float auc() {
        return this.auc;
    }

    public final UncertaintyRange uncertaintyRange() {
        return this.uncertaintyRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.auc());
        hashCode = 31 * hashCode + Objects.hashCode(this.uncertaintyRange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TFIModelPerformance)) {
            return false;
        }
        TFIModelPerformance other = (TFIModelPerformance)obj;
        return Objects.equals(this.auc(), other.auc()) && Objects.equals(this.uncertaintyRange(), other.uncertaintyRange());
    }

    public final String toString() {
        return ToString.builder((String)"TFIModelPerformance").add("Auc", (Object)this.auc()).add("UncertaintyRange", (Object)this.uncertaintyRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "auc": {
                return Optional.ofNullable(clazz.cast(this.auc()));
            }
            case "uncertaintyRange": {
                return Optional.ofNullable(clazz.cast(this.uncertaintyRange()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TFIModelPerformance, T> g) {
        return obj -> g.apply((TFIModelPerformance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float auc;
        private UncertaintyRange uncertaintyRange;

        private BuilderImpl() {
        }

        private BuilderImpl(TFIModelPerformance model) {
            this.auc(model.auc);
            this.uncertaintyRange(model.uncertaintyRange);
        }

        public final Float getAuc() {
            return this.auc;
        }

        public final void setAuc(Float auc) {
            this.auc = auc;
        }

        @Override
        public final Builder auc(Float auc) {
            this.auc = auc;
            return this;
        }

        public final UncertaintyRange.Builder getUncertaintyRange() {
            return this.uncertaintyRange != null ? this.uncertaintyRange.toBuilder() : null;
        }

        public final void setUncertaintyRange(UncertaintyRange.BuilderImpl uncertaintyRange) {
            this.uncertaintyRange = uncertaintyRange != null ? uncertaintyRange.build() : null;
        }

        @Override
        public final Builder uncertaintyRange(UncertaintyRange uncertaintyRange) {
            this.uncertaintyRange = uncertaintyRange;
            return this;
        }

        public TFIModelPerformance build() {
            return new TFIModelPerformance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TFIModelPerformance> {
        public Builder auc(Float var1);

        public Builder uncertaintyRange(UncertaintyRange var1);

        default public Builder uncertaintyRange(Consumer<UncertaintyRange.Builder> uncertaintyRange) {
            return this.uncertaintyRange((UncertaintyRange)((UncertaintyRange.Builder)UncertaintyRange.builder().applyMutation(uncertaintyRange)).build());
        }
    }
}

