/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.ElementsListCopier;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.ListUpdateMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateListRequest
extends FraudDetectorRequest
implements ToCopyableBuilder<Builder, UpdateListRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateListRequest.getter(UpdateListRequest::name)).setter(UpdateListRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> ELEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("elements").getter(UpdateListRequest.getter(UpdateListRequest::elements)).setter(UpdateListRequest.setter(Builder::elements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateListRequest.getter(UpdateListRequest::description)).setter(UpdateListRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> UPDATE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updateMode").getter(UpdateListRequest.getter(UpdateListRequest::updateModeAsString)).setter(UpdateListRequest.setter(Builder::updateMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateMode").build()}).build();
    private static final SdkField<String> VARIABLE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("variableType").getter(UpdateListRequest.getter(UpdateListRequest::variableType)).setter(UpdateListRequest.setter(Builder::variableType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ELEMENTS_FIELD, DESCRIPTION_FIELD, UPDATE_MODE_FIELD, VARIABLE_TYPE_FIELD));
    private final String name;
    private final List<String> elements;
    private final String description;
    private final String updateMode;
    private final String variableType;

    private UpdateListRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.elements = builder.elements;
        this.description = builder.description;
        this.updateMode = builder.updateMode;
        this.variableType = builder.variableType;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasElements() {
        return this.elements != null && !(this.elements instanceof SdkAutoConstructList);
    }

    public final List<String> elements() {
        return this.elements;
    }

    public final String description() {
        return this.description;
    }

    public final ListUpdateMode updateMode() {
        return ListUpdateMode.fromValue(this.updateMode);
    }

    public final String updateModeAsString() {
        return this.updateMode;
    }

    public final String variableType() {
        return this.variableType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasElements() ? this.elements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.variableType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateListRequest)) {
            return false;
        }
        UpdateListRequest other = (UpdateListRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && this.hasElements() == other.hasElements() && Objects.equals(this.elements(), other.elements()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.updateModeAsString(), other.updateModeAsString()) && Objects.equals(this.variableType(), other.variableType());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateListRequest").add("Name", (Object)this.name()).add("Elements", (Object)(this.elements() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)this.description()).add("UpdateMode", (Object)this.updateModeAsString()).add("VariableType", (Object)this.variableType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "elements": {
                return Optional.ofNullable(clazz.cast(this.elements()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "updateMode": {
                return Optional.ofNullable(clazz.cast(this.updateModeAsString()));
            }
            case "variableType": {
                return Optional.ofNullable(clazz.cast(this.variableType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateListRequest, T> g) {
        return obj -> g.apply((UpdateListRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorRequest.BuilderImpl
    implements Builder {
        private String name;
        private List<String> elements = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String updateMode;
        private String variableType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateListRequest model) {
            super(model);
            this.name(model.name);
            this.elements(model.elements);
            this.description(model.description);
            this.updateMode(model.updateMode);
            this.variableType(model.variableType);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getElements() {
            if (this.elements instanceof SdkAutoConstructList) {
                return null;
            }
            return this.elements;
        }

        public final void setElements(Collection<String> elements) {
            this.elements = ElementsListCopier.copy(elements);
        }

        @Override
        public final Builder elements(Collection<String> elements) {
            this.elements = ElementsListCopier.copy(elements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elements(String ... elements) {
            this.elements(Arrays.asList(elements));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getUpdateMode() {
            return this.updateMode;
        }

        public final void setUpdateMode(String updateMode) {
            this.updateMode = updateMode;
        }

        @Override
        public final Builder updateMode(String updateMode) {
            this.updateMode = updateMode;
            return this;
        }

        @Override
        public final Builder updateMode(ListUpdateMode updateMode) {
            this.updateMode(updateMode == null ? null : updateMode.toString());
            return this;
        }

        public final String getVariableType() {
            return this.variableType;
        }

        public final void setVariableType(String variableType) {
            this.variableType = variableType;
        }

        @Override
        public final Builder variableType(String variableType) {
            this.variableType = variableType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateListRequest build() {
            return new UpdateListRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateListRequest> {
        public Builder name(String var1);

        public Builder elements(Collection<String> var1);

        public Builder elements(String ... var1);

        public Builder description(String var1);

        public Builder updateMode(String var1);

        public Builder updateMode(ListUpdateMode var1);

        public Builder variableType(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

