/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorClient;
import software.amazon.awssdk.services.frauddetector.internal.UserAgentUtils;
import software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsRequest;
import software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsResponse;

public class DescribeModelVersionsIterable
implements SdkIterable<DescribeModelVersionsResponse> {
    private final FraudDetectorClient client;
    private final DescribeModelVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeModelVersionsIterable(FraudDetectorClient client, DescribeModelVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeModelVersionsResponseFetcher();
    }

    public Iterator<DescribeModelVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeModelVersionsResponseFetcher
    implements SyncPageFetcher<DescribeModelVersionsResponse> {
        private DescribeModelVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeModelVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeModelVersionsResponse nextPage(DescribeModelVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeModelVersionsIterable.this.client.describeModelVersions(DescribeModelVersionsIterable.this.firstRequest);
            }
            return DescribeModelVersionsIterable.this.client.describeModelVersions((DescribeModelVersionsRequest)((Object)DescribeModelVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

