/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorClient;
import software.amazon.awssdk.services.frauddetector.internal.UserAgentUtils;
import software.amazon.awssdk.services.frauddetector.model.GetBatchImportJobsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetBatchImportJobsResponse;

public class GetBatchImportJobsIterable
implements SdkIterable<GetBatchImportJobsResponse> {
    private final FraudDetectorClient client;
    private final GetBatchImportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetBatchImportJobsIterable(FraudDetectorClient client, GetBatchImportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetBatchImportJobsResponseFetcher();
    }

    public Iterator<GetBatchImportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetBatchImportJobsResponseFetcher
    implements SyncPageFetcher<GetBatchImportJobsResponse> {
        private GetBatchImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(GetBatchImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetBatchImportJobsResponse nextPage(GetBatchImportJobsResponse previousPage) {
            if (previousPage == null) {
                return GetBatchImportJobsIterable.this.client.getBatchImportJobs(GetBatchImportJobsIterable.this.firstRequest);
            }
            return GetBatchImportJobsIterable.this.client.getBatchImportJobs((GetBatchImportJobsRequest)((Object)GetBatchImportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

